package com.lwby.marketing.att.bystory.handle;

import com.alibaba.fastjson.JSON;
import com.lwby.marketing.att.AttributionStatus;
import com.lwby.marketing.att.novel.AttributionType;
import com.lwby.marketing.att.bystory.DyStoryUniversalProcess;
import com.lwby.marketing.flow.NodeSwitchFlow;
import com.lwby.marketing.vo.StoryNovelAction;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

/**
 * @author songxinyu
 * @version PaySpduFlow.java, v 0.1 2024年03月04日 18:46 songxinyu Exp $
 */
@Slf4j
@Component("dystory_payspdu")
public class PaySpduFlow extends NodeSwitchFlow<StoryNovelAction> {

    private static final Logger DYSTORY_SYS_LOG   = LoggerFactory.getLogger("dystory.sys");

    @Resource
    DyStoryUniversalProcess up;

    @Override
    public boolean checked(StoryNovelAction action) {
        return action.getType() == 2;
    }

    @Override
    public void process(StoryNovelAction action) {
        int platformId = action.getPlatformId();
        Long channelId = action.getChannelId();
        String shaveMakeCall = up.getAttributeRuleByPlatformIdAndChannelId(platformId,channelId);
        if (StringUtils.isEmpty(shaveMakeCall)) {
            //直接回传,走回传流
            DYSTORY_SYS_LOG.info("PaySpduFlow process0 attribute is null,platformId={},channelId={}",action.getPlatformId(),action.getChannelId());
            return;
        }
        /**
         * 金额扣量规则
         * 商品id  ： 回传
         * {
         *   "1" : 85,
         *   "2" : 90,
         *   "3" : 40,
         *   "4" : 100
         * }
         */

        Map<String, Integer> map = JSON.parseObject(shaveMakeCall, Map.class);

        Integer sprDedu = 0;
        String goodId = action.getGoodId();

        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            String key = entry.getKey();
            if (key.equals(goodId)) {
                sprDedu = entry.getValue();
                break;
            }
        }

        if (sprDedu == 100) {
            DYSTORY_SYS_LOG.info("PaySpduFlow process0 attribute.sprDeduChannel 100,platformId={},channelId={}",action.getPlatformId(),action.getChannelId());
            return;
        }

        //总数
        String channelTotal =  up.getTotalCountKey(AttributionType.CHANNEL, action.getPlatformId(), action.getChannelId(),goodId, sprDedu, action.getCurrentDateStr());
        //回传
        String channelCallback = up.getCallbackCountKey(AttributionType.CHANNEL, action.getPlatformId(), action.getChannelId(),goodId, sprDedu, action.getCurrentDateStr());

        long channelTotalCount = up.incrby(channelTotal, 0, 60 * 60 * 24);
        long channelCallbackCount = up.incrby(channelCallback, 0, 60 * 60 * 24);

        up.incrby(channelTotal, 1);

            if (isCallback(channelTotalCount, channelCallbackCount, sprDedu)) {
            //回传，回传个数 + 1
            up.incrby(channelCallback, 1);
            DYSTORY_SYS_LOG.info(
                    "PaySpduFlow.process0.deduction doing dynamic, platformId = {}, channel = {}, sprDedu = {}, goodId = {}, channelTotalCount = {}, channelCallbackCount = {}, v = {}",
                    platformId, channelId, sprDedu, goodId, channelTotalCount, channelCallbackCount, 1);
        } else {
            up.notifyResult(action,"ocpc_pay", AttributionStatus.NORMAL_DEDUCTION_CALLBACK);
            up.set(up.getFirstCheckerKey(action),60 * 60 * 24,"1");
            DYSTORY_SYS_LOG.info(
                    "PaySpduFlow.process0.deduction doing dynamic, platformId = {}, channel = {}, sprDedu = {}, goodId = {}, channelTotalCount = {}, channelCallbackCount = {}, v = {}",
                    platformId, channelId, sprDedu, goodId, channelTotalCount, channelCallbackCount, 0);
        }
    }

    private boolean isCallback(long channelTotalCount, long channelCallbackCount, Integer sprDedu) {
        if (channelTotalCount == 0) {
            //首次随机
            return ThreadLocalRandom.current().nextInt(1, 3) == 1;
        }
        //计算回传率
        BigDecimal divide = new BigDecimal(channelCallbackCount).divide(new BigDecimal(channelTotalCount), 4, RoundingMode.HALF_UP);
        //比较回传率和扣量比例，决定是否回传
        double percent = (double) Math.round(sprDedu * 100 / 100.0) / 100;
        return divide.compareTo(BigDecimal.valueOf(percent).setScale(4, RoundingMode.HALF_UP)) != 1;
    }
}
