package com.lwby.marketing.att.novel;

import com.alibaba.fastjson.JSON;
import com.lwby.marketing.flow.FlowExecutor;
import com.lwby.marketing.flow.Rule;
import com.lwby.marketing.vo.BookStoreEvent;
import com.lwby.marketing.vo.NovelAction;
import lombok.extern.slf4j.Slf4j;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.listener.MessageListener;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.List;

/**
 * @author songxinyu
 * @version NovelActiveConsumer.java, v 0.1 2024年03月05日 10:40 songxinyu Exp $
 */
@Slf4j
@Component
public class NovelActiveConsumer {

    @Resource
    ApplicationContext ctx;

    FlowExecutor<NovelAction> executorNovel;

    private static final Logger NOVEL_SYS_LOG = LoggerFactory.getLogger("novel.sys");

    private static final Logger NOVEL_ERROR_LOG = LoggerFactory.getLogger("novel.error");

    @PostConstruct
    public void init(){
        executorNovel = new FlowExecutor<>(ctx, Rule.create().THEN("novel_setup").THEN("novel_prize").THEN("novel_store").THEN("novel_checkerfirst").SWITCH("novel_cross","novel_plan","novel_channel"));
    }

    @KafkaListener(topics = {"${system.consumer.novel.active.topic}"} ,containerFactory = "kafkaListenerContainerFactoryNovelActive")
    public void onMessage(List<ConsumerRecord<String, String>> datas) {

        long begin = System.currentTimeMillis();
        if (NOVEL_SYS_LOG.isInfoEnabled()) {
            NOVEL_SYS_LOG.info("media.active.onMessage start ,size = {}", datas.size());
        }


        for (ConsumerRecord<String, String> data : datas) {
            try {
                if (data == null) {
                    log.warn("media.active.story.onMessage listen 消费数据为null");
                    return;
                }

                NOVEL_SYS_LOG.info("media.active.onMessage start, data={}", data == null ? null : data.value());

                BookStoreEvent event = JSON.parseObject(data.value(), BookStoreEvent.class);
                NOVEL_SYS_LOG.info("media.active.topic={}, bookStoreEvent={}", data.topic(), JSON.toJSONString(event));

                NovelAction action = new NovelAction(event.getClientInfo(), data.value());

                executorNovel.execute(action);
            } catch (Throwable e) {
                NOVEL_ERROR_LOG.info("media.active.onMessage failed, data={}, costTime={} ms", data.value(),
                        System.currentTimeMillis() - begin, e);
            }
        }

    }
}