package com.lwby.marketing.util;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;

/**
 * @author martin.ad
 * @Description: 非线程安全工具类，且把buf曝露在外不安全，只为内存复用和高性能，慎用。
 * @date 创建时间： 2022/11/17 18:21
 */
public
class CharStream extends Writer {
    protected char buf[];

    protected int count;

    public CharStream() {
        this(32);
    }

    public CharStream(String initStr){
        this(initStr.length());
        this.buf = initStr.toCharArray();
        this.count = initStr.length();
    }

    public char[] getChars(){
        return this.buf;
    }

    public int getCount(){
        return this.count;
    }

    public void copy(CharStream cs){
        reset();
        write(cs.getChars(),0,cs.getCount());
    }

    public void copy(String str){
        reset();
        write(str,0,str.length());
    }

    public CharStream clone(){
        CharStream _cs = new CharStream(this.count);
        _cs.write(buf,0,this.count);
        return _cs;
    }

    public void group(CharStream[] csa,char separtor,CharStream defalut){
        reset();
        for(CharStream _cs:csa){
            write(_cs.getCount() == 0?defalut:_cs);
            write(separtor);
        }
        count--;
    }

    public boolean equals(char[] chars){
        int n = chars.length;
        if (count == n) {
            for(int i=0;i<n;i++){
                if (buf[i] != chars[i])
                    return false;
            }
            return true;
        }
        return false;
    }

    public CharStream(int initialSize) {
        if (initialSize < 0) {
            throw new IllegalArgumentException("Negative initial size: "
                    + initialSize);
        }
        buf = new char[initialSize];
    }

    public void write(int c) {
        int newcount = count + 1;
        if (newcount > buf.length) {
            buf = Arrays.copyOf(buf, Math.max(buf.length << 1, newcount));
        }
        buf[count] = (char)c;
        count = newcount;
    }

    public void write(CharStream cs) {
        write(cs.getChars(),0,cs.getCount());
    }

    public void write(char c[], int off, int len) {
        if ((off < 0) || (off > c.length) || (len < 0) ||
                ((off + len) > c.length) || ((off + len) < 0)) {
            throw new IndexOutOfBoundsException();
        } else if (len == 0) {
            return;
        }
        int newcount = count + len;
        if (newcount > buf.length) {
            buf = Arrays.copyOf(buf, Math.max(buf.length << 1, newcount));
        }
        System.arraycopy(c, off, buf, count, len);
        count = newcount;
    }

    public void write(String str, int off, int len) {
        int newcount = count + len;
        if (newcount > buf.length) {
            buf = Arrays.copyOf(buf, Math.max(buf.length << 1, newcount));
        }
        str.getChars(off, off + len, buf, count);
        count = newcount;
    }

    public void writeTo(Writer out) throws IOException {
        out.write(buf, 0, count);
    }


    public CharStream append(CharSequence csq) {
        String s = (csq == null ? "null" : csq.toString());
        write(s, 0, s.length());
        return this;
    }

    public CharStream append(CharSequence csq, int start, int end) {
        String s = (csq == null ? "null" : csq).subSequence(start, end).toString();
        write(s, 0, s.length());
        return this;
    }

    public CharStream append(char c) {
        write(c);
        return this;
    }

    public void reset() {
        count = 0;
    }

    public char toCharArray()[] {
        return Arrays.copyOf(buf, count);
    }

    public int size() {
        return count;
    }

    public String toString() {
         return new String(buf, 0, count);
    }

    public void flush() { }

    public void close() { }
}