package com.lwby.marketing.att.bystory;

import com.lwby.marketing.flow.FlowExecutor;
import com.lwby.marketing.flow.Rule;
import com.lwby.marketing.vo.StoryNovelAction;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;

@Component
public class DyStoryFlowExecutor {

    @Resource
    ApplicationContext ctx;
    FlowExecutor<StoryNovelAction> executorByStory;

    @PostConstruct
    public void init(){
        executorByStory = new FlowExecutor<>(ctx, Rule.create().THEN("dystory_setup").THEN("dystory_store").THEN("dystory_checkerfirst").SWITCH("dystory_payspdu").THEN("dystory_uploadcall"));
    }

    public FlowExecutor<StoryNovelAction> getExecutorByStory(){
        return this.executorByStory;
    }
}
