package com.lwby.marketing.att.bystory;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.lwby.marketing.vo.StoryNovelAction;
import com.lwby.marketing.vo.StoreUserUploadEventBO;
import lombok.extern.slf4j.Slf4j;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.listener.MessageListener;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;

/**
 * @author songxinyu
 * @version StoreNovelPayConsumer.java, v 0.1 2024年03月05日 10:40 songxinyu Exp $
 */
@Slf4j
@Component
public class DyStoryPayConsumer extends DyStoryFlowExecutor implements MessageListener<String, String> {

    @Resource
    DyStoryFlowExecutor dyStoryFlowExecutor;

    @KafkaListener(topics = {"${system.consumer.dystory.pay.topic}"},groupId = "${system.consumer.dystory.pay.group_id}")
    @Override
    public void onMessage(ConsumerRecord<String, String> data) {

        long begin = System.currentTimeMillis();
        if (log.isInfoEnabled()) {
            log.info("media.pay.story.onMessage start, data={}", data == null ? null : data.value());
        }
        if (data != null) {
            try {
                StoreUserUploadEventBO event = JSONObject.parseObject(data.value(), StoreUserUploadEventBO.class);

                if (log.isInfoEnabled()) {
                    log.info("media.pay.story.topic={}, bookStoreEvent={}", data.topic(), JSON.toJSONString(event));
                }

                StoryNovelAction action = new StoryNovelAction(event.getClientInfo(),event.getUserId(),event.getOpenId(),event.getUserUploadEvent(),event.getProductId());

                dyStoryFlowExecutor.getExecutorByStory().execute(action);
            } catch (Throwable e) {
                log.error("story.novel.pay.onMessage failed, data={}, costTime={} ms", data.value(),
                        System.currentTimeMillis() - begin, e);
            }
        }

    }

}
