package com.lwby.marketing.att.novel;

import com.alibaba.fastjson.JSON;
import com.lwby.marketing.flow.FlowExecutor;
import com.lwby.marketing.flow.Rule;
import com.lwby.marketing.vo.BookStoreEvent;
import com.lwby.marketing.vo.NovelAction;
import lombok.extern.slf4j.Slf4j;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.context.ApplicationContext;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.listener.MessageListener;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;

/**
 * @author songxinyu
 * @version NovelActiveConsumer.java, v 0.1 2024年03月05日 10:40 songxinyu Exp $
 */
@Slf4j
@Component
public class NovelActiveConsumer implements MessageListener<String, String> {

    @Resource
    ApplicationContext ctx;

    FlowExecutor<NovelAction> executorNovel;

    @PostConstruct
    public void init(){
        executorNovel = new FlowExecutor<>(ctx, Rule.create().THEN("novel_setup").THEN("novel_prize").THEN("novel_store").THEN("novel_checkerfirst").SWITCH("novel_cross","novel_plan","novel_channel"));
    }

    @KafkaListener(topics = {"${system.consumer.novel.active.topic}"},groupId = "${system.consumer.novel.active.group_id}")
    @Override
    public void onMessage(ConsumerRecord<String, String> data) {

        long begin = System.currentTimeMillis();
        if (log.isInfoEnabled()) {
            log.info("media.active.onMessage start, data={}", data == null ? null : data.value());
        }
        if (data != null) {
            try {
                BookStoreEvent event = JSON.parseObject(data.value(), BookStoreEvent.class);
                if (log.isInfoEnabled()) {
                    log.info("media.active.topic={}, bookStoreEvent={}", data.topic(), JSON.toJSONString(event));
                }

                NovelAction action = new NovelAction(event.getClientInfo(), data.value());

                executorNovel.execute(action);
            } catch (Throwable e) {
                log.error("novel.active.onMessage failed, data={}, costTime={} ms", data.value(),
                        System.currentTimeMillis() - begin, e);
            }
        }

    }
}