package com.lwby.marketing.att.novel.handle;

import com.lwby.marketing.att.AttributionStatus;
import com.lwby.marketing.att.novel.AttributionType;
import com.lwby.marketing.att.novel.NovelUniversalProcess;
import com.lwby.marketing.flow.NodeSwitchFlow;
import com.lwby.marketing.util.DateTimUtils;
import com.lwby.marketing.vo.NovelAction;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.concurrent.ThreadLocalRandom;


@Component("novel_channel")
public class ChannelAttributionFlow extends NodeSwitchFlow<NovelAction> {

    @Resource
    JdbcTemplate marketingJdbcTemplate;

    @Resource
    NovelUniversalProcess up;

    @Override
    public boolean checked(NovelAction action) {
        return true;
    }

    @Override
    public void process(NovelAction action) {
        process0(action, AttributionType.CHANNEL);
    }

    public void process0(NovelAction action, AttributionType type) {
        //是否是当天注册用户
        boolean isNewUser = DateTimUtils.isCurrentDayTime(action.getRegistrationDate());

        //获取满意配置
        Integer sprDedu = up.getAppChannel(action.getPlatformId(), action.getChannelId());

        //等于空 或 100直接回传
        if (sprDedu == null || sprDedu == 100) {
            //TODO;channelTotalCount 和 channelCallbackCount不加吗
            action.getMedia().notify(action);
            up.notifyResult(action, AttributionStatus.ACTIVE_CALLBACK);
            up.set(up.getFirstCheckerKey(action),60 * 60 * 24,"1");
            return;
        }

        //总数
        String channelTotal =  up.getTotalCountKey(type, action.getPlatformId(), action.getChannelId(), sprDedu, action.getCurrentDateStr());
        //回传
        String channelCallback = up.getCallbackCountKey(type, action.getPlatformId(), action.getChannelId(), sprDedu, action.getCurrentDateStr());

        long channelTotalCount = up.incrby(channelTotal, 0, 60 * 60 * 24);
        long channelCallbackCount = up.incrby(channelCallback, 0, 60 * 60 * 24);

        up.incrby(channelTotal, 1);

        //TODO;判断1-30天内是否活跃老用户,如果是则 100% 扣量；
        if(!isNewUser && isAliveByDay(action.getUserId(),30)){
            //TODO;扣量
            up.notifyResult(action,AttributionStatus.OLDUSER_DEDUCTION_CALLBACK);

        }else {
            if (isCallback(channelTotalCount, channelCallbackCount, sprDedu)) {
                //回传，回传个数 + 1
                up.incrby(channelCallback, 1);
                action.getMedia().notify(action);
                up.notifyResult(action, AttributionStatus.ACTIVE_CALLBACK);
            } else {
                up.notifyResult(action, AttributionStatus.NORMAL_DEDUCTION_CALLBACK);
            }
        }
        up.set(up.getFirstCheckerKey(action),60 * 60 * 24,"1");
    }

    private boolean isCallback(long channelTotalCount, long channelCallbackCount, Integer sprDedu) {
        if (channelTotalCount == 0) {
            //首次随机
            return ThreadLocalRandom.current().nextInt(1, 3) == 1;
        }
        //计算回传率
        BigDecimal divide = new BigDecimal(channelCallbackCount).divide(new BigDecimal(channelTotalCount), 4, RoundingMode.HALF_UP);
        //比较回传率和扣量比例，决定是否回传
        double percent = (double) Math.round(sprDedu * 100 / 100.0) / 100;
        return divide.compareTo(BigDecimal.valueOf(percent).setScale(4, RoundingMode.HALF_UP)) != 1;
    }

    /**
     * 用户在指定天数内是否有活跃
     * @param userId
     * @param day
     * @return
     */
    public boolean isAliveByDay(long userId, int day){
        return marketingJdbcTemplate.queryForMap(String.format("select 1 from lwby_marketing_growth.alive_olduser where user_id ='%d' and last_alive_date  >= CURDATE() - INTERVAL %d DAY",userId,day)).size() > 0;
    }
}