package com.lwby.marketing.att.novel.handle;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.lwby.marketing.att.novel.NovelUniversalProcess;
import com.lwby.marketing.flow.NodeFlow;
import com.lwby.marketing.util.DateTimUtils;
import com.lwby.marketing.vo.NovelAction;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Objects;

@Component("novel_prize")
public class PrizeSevenUserFlow extends NodeFlow<NovelAction> {

    //TODO;建议参数先写死
    @Value("${platformPrizeExpire:{}}")
    private String platformPrizeExpire;

    @Resource
    NovelUniversalProcess up;

    @Override
    public void process(NovelAction action) {
        if(DateTimUtils.isTimeGreaterThanSevenDays(action.getRegistrationDate())){
            //代码有问题
            JSONObject platformPrizeExpireJson = JSON.parseObject(platformPrizeExpire);
            Integer platformPrizeExpireStr = platformPrizeExpireJson.getInteger(String.valueOf(action.getPlatformId()));

            String prizeAssembleKey = NovelUniversalProcess.PRIZE_FLOW_PREFIX;
            if (Objects.nonNull(platformPrizeExpireStr)) {
                //商业化老用户大奖缓存
                up.set(prizeAssembleKey.concat(String.valueOf(action.getUserId())), platformPrizeExpireStr, "1");
            } else {
                //商业化老用户大奖缓存3天
                up.set(prizeAssembleKey.concat(String.valueOf(action.getUserId())), 60 * 60 * 24 * 3, "1");
            }
        }
    }
}