package com.lwby.marketing.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.lwby.marketing.att.bystory.DyStoryFlowExecutor;
import com.lwby.marketing.att.bystory.DyStoryUniversalProcess;
import com.lwby.marketing.vo.StoryNovelAction;
import com.lwby.marketing.vo.StoreUserUploadEventBO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.Map;

/**
 * @author songxinyu
 * @version AttrController.java, v 0.1 2024年03月05日 17:30 songxinyu Exp $
 */

@RestController
@Slf4j
@RequestMapping(value = "/attr")
public class AttrController {

    @Resource
    DyStoryUniversalProcess up;

    @Resource
    private KafkaTemplate<String, String> kafkaTemplate;

    @Resource
    DyStoryFlowExecutor dyStoryFlowExecutor;

    @RequestMapping("/testUpload")
    public void testUpload() {
        String msg = "{\"clientInfo\":{\"channel\":214120503,\"clientIp\":\"183.219.7.180\",\"pkv\":1,\"platformGroupId\":412,"
                + "\"platformId\":412,\"sessionid\":\"undefined\",\"ua\":\"Mozilla/5.0 (Linux; Android 12; OXF-AN00 Build/HUAWEIOXF-AN00;"
                + " wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/117.0.0.0 Mobile Safari/537.36 aweme.lite/28.9.0 "
                + "ToutiaoMicroApp/3.14.0 PluginVersion/28909073\",\"version\":\"2.0.0\",\"xClient\":\"version=2.0.0;platformId=412;"
                + "equipment=android\"},\"createTime\":1709533439693,\"extraData\":{},\"id\":\"93857260-8130-442f-bc92-b549dbf28ef0\","
                + "\"userId\":875325,\"userUploadEvent\":2,\"productId\":\"1\",\"appId\":\"ttd3dda5604ce230b401\","
                + "\"openId\":\"_000HgDjWl-P5-WS9HTQIssNgTnMBRUqDHDu\"}";

        StoreUserUploadEventBO event = JSONObject.parseObject(msg, StoreUserUploadEventBO.class);
        StoryNovelAction action = new StoryNovelAction(event.getClientInfo(),event.getUserId(),event.getOpenId(),event.getUserUploadEvent(),
                event.getProductId());

        try {
            dyStoryFlowExecutor.getExecutorByStory().execute(action);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }



    @RequestMapping("dedu")
    public void testDedu() {
        Integer platformId = 5;
        Integer channelId = 123213;
        Integer sprDedu = up.getAppChannel(platformId, channelId);
        if (sprDedu == null || sprDedu == 100) {
            System.out.println(sprDedu);
        }
        System.out.println(sprDedu);
        String shaveMakeCall = up.getAttributeRuleByPlatformIdAndChannelId(platformId,channelId);
        if (StringUtils.isEmpty(shaveMakeCall)) {
            //直接回传,走回传流
            return;
        }
        /**
         * 金额扣量规则
         * 商品id  ： 回传
         * {
         *   "1" : 85,
         *   "2" : 90,
         *   "3" : 40,
         *   "4" : 100
         * }
         */

        Map<String, Integer> map = JSON.parseObject(shaveMakeCall, Map.class);

        String goodId = "1";

        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            String key = entry.getKey();
            if (key.equals(goodId)) {
                sprDedu = entry.getValue();
                break;
            }
        }

        System.out.println(sprDedu);

//        Function<Integer, IStoryCallback> function = new Function<Integer, IStoryCallback>() {
//            @Override
//            public IStoryCallback apply(Integer c) {
//                return c == 0 ? new JRTTActiveCallback() : new JRTTPayCallback();
//            }
//        };
    }

    @RequestMapping("/send")
    public void testSend() {
        String msg = "{\"clientInfo\":{\"channel\":214120503,\"clientIp\":\"183.219.7.180\",\"pkv\":1,\"platformGroupId\":412,"
                + "\"platformId\":412,\"sessionid\":\"undefined\",\"ua\":\"Mozilla/5.0 (Linux; Android 12; OXF-AN00 Build/HUAWEIOXF-AN00;"
                + " wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/117.0.0.0 Mobile Safari/537.36 aweme.lite/28.9.0 "
                + "ToutiaoMicroApp/3.14.0 PluginVersion/28909073\",\"version\":\"2.0.0\",\"xClient\":\"version=2.0.0;platformId=412;"
                + "equipment=android\"},\"createTime\":1709533439693,\"extraData\":{},\"id\":\"93857260-8130-442f-bc92-b549dbf28ef0\","
                + "\"userId\":875325,\"userUploadEvent\":0,\"appId\":\"ttd3dda5604ce230b401\","
                + "\"openId\":\"_000HgDjWl-P5-WS9HTQIssNgTnMBRUqDHDu\"}";

        StoreUserUploadEventBO event = JSONObject.parseObject(msg, StoreUserUploadEventBO.class);

        kafkaTemplate.send("testStoryNovelActive",JSON.toJSONString(event)).addCallback(success -> {
            // 消息发送到的topic
            String topic = success.getRecordMetadata().topic();
            // 消息发送到的分区
            int partition = success.getRecordMetadata().partition();
            // 消息在分区内的offset
            long offset = success.getRecordMetadata().offset();
            log.info("dystory短篇注册发送消息成功: topic={},partition={},offset={}", topic, partition, offset);
        }, failure -> {
            log.error("dystory短篇注册发送消息失败:fail={}", JSON.toJSONString(failure));
        });
    }

    @RequestMapping("/sendPay")
    public void testSendPay() {
        String msg = "{\"clientInfo\":{\"channel\":214120503,\"clientIp\":\"183.219.7.180\",\"pkv\":1,\"platformGroupId\":412,"
                + "\"platformId\":412,\"sessionid\":\"undefined\",\"ua\":\"Mozilla/5.0 (Linux; Android 12; OXF-AN00 Build/HUAWEIOXF-AN00;"
                + " wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/117.0.0.0 Mobile Safari/537.36 aweme.lite/28.9.0 "
                + "ToutiaoMicroApp/3.14.0 PluginVersion/28909073\",\"version\":\"2.0.0\",\"xClient\":\"version=2.0.0;platformId=412;"
                + "equipment=android\"},\"createTime\":1709533439693,\"extraData\":{},\"id\":\"93857260-8130-442f-bc92-b549dbf28ef0\","
                + "\"userId\":875325,\"userUploadEvent\":2,\"productId\":\"1\",\"appId\":\"ttd3dda5604ce230b401\","
                + "\"openId\":\"_000HgDjWl-P5-WS9HTQIssNgTnMBRUqDHDu\"}";

        StoreUserUploadEventBO event = JSONObject.parseObject(msg, StoreUserUploadEventBO.class);

        kafkaTemplate.send("testStoryNovelpay",JSON.toJSONString(event)).addCallback(success -> {
            // 消息发送到的topic
            String topic = success.getRecordMetadata().topic();
            // 消息发送到的分区
            int partition = success.getRecordMetadata().partition();
            // 消息在分区内的offset
            long offset = success.getRecordMetadata().offset();
            log.info("dystory短篇付费发送消息成功: topic={},partition={},offset={}", topic, partition, offset);
        }, failure -> {
            log.error("dystory短篇付费发送消息失败:fail={}", JSON.toJSONString(failure));
        });
    }
}
