package com.lwby.marketing.flow;

import lombok.Data;
import org.springframework.context.ApplicationContext;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;


public class FlowExecutor<T extends Action> {
    private final List<FlowWrapper<T>> flowList;

    public FlowExecutor(ApplicationContext ctx,Rule rule){
        flowList = new ArrayList<>();
        for (Object o : rule.getRuleList()) {
            if(o instanceof String[]){
                flowList.add(new FlowWrapper<>(Arrays.stream((String[])o).map(s->(IFlow<T>)ctx.getBean(s, IFlow.class)).toArray(size -> new IFlow[size])));

            }else{
                flowList.add(new FlowWrapper<>((IFlow<T>)ctx.getBean((String)o, IFlow.class)));
            }
        }
        
    }

    public void execute(T action) throws Exception {
        for (FlowWrapper<T> wrapper : flowList) {
            if(wrapper.type == Type.SWITCH_NODE){
                executeSwitchNode(wrapper,action);
            }else{
                executeNormalNode(wrapper,action);
            }
            if(action.isStop()){
                break;
            }
        }
    }

    private void executeSwitchNode(FlowWrapper<T> wrapper, T action) throws Exception {
        for (IFlow<T> flow : wrapper.getFlows()) {
            if (flow.checked(action) && !action.isStop()) {
                flow.process(action);
                break;
            }
        }
    }

    private void executeNormalNode(FlowWrapper<T> wrapper, T action) throws Exception {
        if (wrapper.getFlow().checked(action) && !action.isStop()) {
            wrapper.getFlow().process(action);
        }
    }

    @Data
    static class FlowWrapper<T extends Action> {
        IFlow<T> flow;
        IFlow<T>[] flows;
        Type type;

        FlowWrapper(IFlow<T> flow) {
            this.flow = flow;
            this.type = Type.NODE;
        }

        FlowWrapper(IFlow<T>[] flows) {
            this.flows = flows;
            this.type = Type.SWITCH_NODE;
        }
    }
    enum Type{
        NODE,SWITCH_NODE
    }
}
