package com.lwby.marketing.notify.media.gdt;

import cn.hutool.crypto.SecureUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.lwby.marketing.notify.MobileNotify;
import com.lwby.marketing.notify.media.gdt.dto.Action;
import com.lwby.marketing.notify.media.gdt.dto.GdtAttributeRequest;
import com.lwby.marketing.notify.media.gdt.dto.UserId;
import com.lwby.marketing.vo.ClientInfo;
import com.lwby.marketing.vo.DeliveryDeviceInfo;
import com.lwby.marketing.vo.NovelAction;
import lombok.extern.slf4j.Slf4j;

import java.util.Collections;

@Slf4j
public class NovelGDTNotify extends MobileNotify {

    public boolean android(NovelAction na){
        DeliveryDeviceInfo ddi = na.getDeliveryDeviceInfo();
        ClientInfo ci = na.getClientInfo();

        StringBuilder sb = new StringBuilder(ddi.getCallback_url());

        UserId ui = UserId.builder()
                .ip(ci.getClientIp())
                .oaid(ci.getOaid())
                .hash_oaid(SecureUtil.md5(ci.getOaid()))
                .hash_imei(ci.getImei())
                .hash_android_id(ci.getAndroidid())
                .user_agent(ci.getUa())
                .build();

        Action action = Action.builder().action_time(System.currentTimeMillis() / 1000)
                .user_id(ui)
                .action_type("ACTIVATE_APP").build();

        GdtAttributeRequest dto = GdtAttributeRequest.builder()
                .actions(Collections.singletonList(action))
                .build();

        String userAction = JSONObject.toJSONString(dto);
        try {
            //TODO;测试不执行
//            String result = HttpUtil.post(sb.toString(), userAction);
//            Integer resultCode = (Integer) JSON.parseObject(result).get("code");
//            return resultCode == 0;
            log.info("Callback info:{}",userAction);
            return true;
        } catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean ios(NovelAction na) {
        throw new UnsupportedOperationException("GDTCallback:ios() Method not implemented");
    }
}
