package com.pika.proxy;

import com.pika.proxy.conf.PikaProxyConfig;
import com.pika.proxy.handler.PikaCmdHandler;
import com.pika.proxy.server.Server;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;

@SpringBootApplication
@RestController
public class WebApplication {
        @Resource
        private PikaProxyConfig config;

        @Resource
        private PikaCmdHandler handler;

        @PostConstruct
        public void start() {
                Server server = new Server(config.getPort(), config.getMaxIdle(), config.getMaxTotal(), handler);
                Runtime.getRuntime().addShutdownHook(new Thread(server::destroy));
        }

        public static void main(String... args) {
                SpringApplication.run(WebApplication.class, args);
        }
}
