package com.pika.proxy.invoke;

import com.pika.proxy.server.codec.PikaCmd;
import com.pika.proxy.handler.CmdHandler;
import com.pika.proxy.result.Result;
import com.pika.proxy.result.ErrorResult;

import java.lang.reflect.Method;


public class PikaCmdInvokeImpl implements CmdInvoke {

        private final Class<?>[] types;
        private final Method method;
        private final CmdHandler handler;

        public PikaCmdInvokeImpl(Class<?>[] types, Method method, CmdHandler handler) {
                this.types = types;
                this.method = method;
                this.handler = handler;
        }

        @Override
        public Result<?> execute(String name, PikaCmd cmd) throws Exception {
                if (!cmd.checkArgNum(types.length)) {
                        return new ErrorResult("wrong number of args for '" + name + "' command");
                }
                Object[] objects = new Object[types.length];
                cmd.toArguments(objects, types);
                return (Result<?>) method.invoke(handler, objects);
        }

}
