package com.pika.proxy.result;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class BulkResult extends Result<ByteBuf> {

        public static final BulkResult NIL_REPLY = new BulkResult();

        public static final char MARKER = '$';
        private final ByteBuf bytes;
        private final int capacity;

        public BulkResult() {
                bytes = null;
                capacity = -1;
        }

        public BulkResult(byte[] bytes) {
        		if (bytes != null) {
        			this.bytes = Unpooled.wrappedBuffer(bytes);
        			this.capacity = bytes.length;
        		} else {
        			this.bytes = null;
                    this.capacity = -1;
        		}
        }

        public BulkResult(Double value) {
                byte[] data = value.toString().getBytes(StandardCharsets.UTF_8);
                this.bytes = Unpooled.wrappedBuffer(data);
                capacity = data.length;
        }

        @Override
        public ByteBuf data() {
                return bytes;
        }


        public String asUTF8String() {
                if (bytes == null) {
                        return null;
                }
                return bytes.toString(Charsets.UTF_8);
        }


        @Override
        public void write(ByteBuf os) throws IOException {
                os.writeByte(MARKER);
                os.writeBytes(numToBytes(capacity, true));
                if (capacity >= 0) {
                        os.writeBytes(bytes);
                        os.writeBytes(CRLF);
                }
        }

        public String toString() {
                return asUTF8String();
        }
}
