package com.pika.proxy.result;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;

import java.io.IOException;

public class ErrorResult extends Result<String> {

        public static final char MARKER = '-';
        public static final ErrorResult NYI_RESP = new ErrorResult("not implemented");
        public static final ErrorResult SHARD_DISABLE_RESP = new ErrorResult("shard disable");
        private final String error;

        public ErrorResult(String error) {
                this.error = error;
        }

        public ErrorResult(Exception e) {
                this.error = e.getCause().toString();
        }

        @Override
        public String data() {
                return error;
        }

        @Override
        public void write(ByteBuf os) {
                os.writeByte(MARKER);
                os.writeBytes(error.getBytes(Charsets.UTF_8));
                os.writeBytes(CRLF);
        }

        public String toString() {
                return error;
        }
}
