package com.pika.proxy.result;

import io.netty.buffer.ByteBuf;

import java.io.IOException;

public class IntegerResult extends Result<Long> {

        public static final char MARKER = ':';
        private final long integer;

        private static IntegerResult[] replies = new IntegerResult[512];

        static {
                for (int i = -255; i < 256; i++) {
                        replies[i + 255] = new IntegerResult(i);
                }
        }

        public static IntegerResult integer(long integer) {
                if (integer > -256 && integer < 256) {
                        return replies[((int) (integer + 255))];
                } else {
                        return new IntegerResult(integer);
                }
        }

        public IntegerResult(long integer) {
                this.integer = integer;
        }

        public IntegerResult(boolean integer) {
                this.integer = integer ? 1 : 0;
        }

        @Override
        public Long data() {
                return integer;
        }

        @Override
        public void write(ByteBuf os) throws IOException {
                os.writeByte(MARKER);
                os.writeBytes(Result.numToBytes(integer, true));
        }

        public String toString() {
                return data().toString();
        }
}
