package com.pika.proxy.result;

import io.netty.buffer.ByteBuf;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultiBulkResult extends Result<Result[]> {

        public static final char MARKER = '*';
        public static final MultiBulkResult EMPTY = new MultiBulkResult(new Result[0]);

        private Result[] replies;

        public MultiBulkResult(Result[] replies) {
        		if (replies != null) {
        			this.replies = replies;
        		} else {
        			this.replies = new Result[0];
        		}
        }

        public MultiBulkResult(Map<byte[], byte[]> map) {
        		if (map == null || map.isEmpty()) {
        			this.replies = new Result[0];
        		} else {
	                int i = 0;
	                replies = new BulkResult[map.size() * 2];
	                Set<byte[]> keys = map.keySet();
	                for (byte[] key : keys) {
	                        replies[i++] = new BulkResult(key);
	                        replies[i++] = new BulkResult(map.get(key));
	                }
        		}
        }

        public MultiBulkResult(Set<byte[]> set) {
	        	if (set == null || set.isEmpty()) {
	    			this.replies = new Result[0];
	    		} else {
	                int i = 0;
	                replies = new BulkResult[set.size()];
	                for (byte[] key : set) {
	                        replies[i++] = new BulkResult(key);
	                }
	    		}
        }

        public MultiBulkResult(List<String> set) {
	        	if (set == null || set.isEmpty()) {
	    			this.replies = new Result[0];
	    		} else {
	                int i = 0;
	                replies = new BulkResult[set.size()];
	                for (String key : set) {
	                        replies[i++] = new BulkResult(key.getBytes(StandardCharsets.UTF_8));
	                }
	    		}
        }

        public MultiBulkResult(Collection<byte[]> coll) {
	        	if (coll == null || coll.isEmpty()) {
	    			this.replies = new Result[0];
	    		} else {
	                int i = 0;
	                replies = new BulkResult[coll.size()];
	                for (byte[] key : coll) {
	                        replies[i++] = new BulkResult(key);
	                }
	    		}
        }

        @Override
        public Result[] data() {
                return replies;
        }

        @Override
        public void write(ByteBuf os) throws IOException {
                os.writeByte(MARKER);
                if (replies == null) {
                        os.writeBytes(NEG_ONE_WITH_CRLF);
                } else {
                        os.writeBytes(numToBytes(replies.length, true));
                        for (Result reply : replies) {
                                reply.write(os);
                        }
                }
        }

}
