package com.pika.proxy.result;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;

import java.io.IOException;

public class StatusResult extends Result<String> {

        public static final char MARKER = '+';
        public static final StatusResult OK = new StatusResult("OK");
        public static final StatusResult QUIT = new StatusResult("OK");
        private final String status;
        private final byte[] statusBytes;

        public StatusResult(String status) {
                this.status = status;
                this.statusBytes = status.getBytes(Charsets.UTF_8);
        }

        @Override
        public String data() {
                return status;
        }

        @Override
        public void write(ByteBuf os) throws IOException {
                os.writeByte(MARKER);
                os.writeBytes(statusBytes);
                os.writeBytes(CRLF);
        }

}
