package com.pika.proxy.server;

import com.pika.proxy.handler.CmdHandler;
import com.pika.proxy.server.codec.PikaCmdDecoder;
import com.pika.proxy.server.codec.PikaCmdEncoder;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;

public class Server {

        private EventLoopGroup boss;

        public Server(final int port, final int minThreads, final int maxThreads, final CmdHandler handler) {
                boss = new NioEventLoopGroup(1);
                ServerBootstrap b = new ServerBootstrap();
                b.group(boss);
                b.channel(NioServerSocketChannel.class);
                b.childHandler(new ChannelInitializer<SocketChannel>() {
                        @Override
                        protected void initChannel(SocketChannel ch){
                                ch.pipeline().addLast(new PikaCmdEncoder());
                                ch.pipeline().addLast(new PikaCmdDecoder());
                                ch.pipeline().addLast(new ServerIdleHandler());
                                ch.pipeline().addLast(new ServerHandler(minThreads, maxThreads, handler));
                        }
                });
                b.option(ChannelOption.SO_BACKLOG, 128);
                b.option(ChannelOption.TCP_NODELAY, true);
                b.childOption(ChannelOption.SO_KEEPALIVE, true);
                try {
                        b.bind(port).sync();
                } catch (InterruptedException e) {
                        e.printStackTrace();
                }

        }

        public void destroy() {
                try {
                        boss.shutdownGracefully();
                } catch (Exception ignored) {
                }
        }
}
