package com.pika.proxy.server;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.TimeUnit;

public class ServerIdleHandler extends IdleStateHandler {

        private static final int SET_IDLE_TIME = 12;
        private final Logger logger = LoggerFactory.getLogger(ServerIdleHandler.class);

        public ServerIdleHandler() {
                super(0, 0, SET_IDLE_TIME, TimeUnit.HOURS);
        }

        @Override
        protected void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) throws Exception {
                ctx.fireUserEventTriggered(evt);
                if (IdleState.ALL_IDLE == evt.state()) {
                        logger.error("idle timeout " + SET_IDLE_TIME + " minutes, close connection  " + ctx.toString());
                        ctx.close();
                }
        }
}
