package com.pika.proxy.server.codec;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class PikaCmd {

        public static final byte[] EMPTY_BYTES = new byte[0];

        private final Object[] objects;

        public PikaCmd(Object[] objects) {
                this.objects = objects;
        }

        public boolean checkArgNum(int argsNum) {
                return argsNum <= objects.length - 1;
        }

        public byte[] getName() {
                return getBytes(objects[0]);
        }

        private byte[] getBytes(Object object) {
                byte[] argument;
                if (object == null) {
                        argument = EMPTY_BYTES;
                } else if (object instanceof byte[]) {
                        argument = (byte[]) object;
                } else if (object instanceof ByteBuf) {
                        argument = ((ByteBuf) object).array();
                } else if (object instanceof String) {
                        argument = ((String) object).getBytes(Charsets.UTF_8);
                } else {
                        argument = object.toString().getBytes(Charsets.UTF_8);
                }
                return argument;
        }

        public void toArguments(Object[] arguments, Class<?>[] types) {
                int position = 0;
                for (Class<?> type : types) {
                        if (position <= 0 && type == String.class) {
                                arguments[position] = new String((byte[]) objects[1 + position], StandardCharsets.UTF_8);
                        } else if (type == int.class) {
                                arguments[position] = Integer.parseInt(new String((byte[]) objects[1 + position], StandardCharsets.UTF_8));
                        } else if (type == long.class) {
                                arguments[position] = Long.parseLong(new String((byte[]) objects[1 + position], StandardCharsets.UTF_8));
                        } else if (type == double.class) {
                                arguments[position] = Double.parseDouble(new String((byte[]) objects[1 + position], StandardCharsets.UTF_8));
                        } else if (type == byte[].class) {
                                arguments[position] = objects[1 + position];
                        } else {
                                int left = objects.length - position - 1;
                                byte[][] lastArgument = new byte[left][];
                                for (int i = 0; i < left; i++) {
                                        lastArgument[i] = (byte[]) objects[i + position + 1];
                                }
                                arguments[position] = lastArgument;
                        }
                        position++;
                }
        }

}
