package com.pika.proxy.server.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import com.pika.proxy.exceptions.PikaException;
import com.pika.proxy.result.BulkResult;
import com.pika.proxy.result.MultiBulkResult;
import com.pika.proxy.result.Result;

import java.io.IOException;
import java.util.List;

import static com.pika.proxy.result.Result.CR;

public class PikaCmdDecoder extends ReplayingDecoder<Void> {

        private byte[][] bytes;
        private int arguments = 0;

        @Override
        protected void decode(ChannelHandlerContext ctx, ByteBuf in,
                List<Object> out) throws Exception {
                if (bytes != null) {
                        int numArgs = bytes.length;
                        for (int i = arguments; i < numArgs; i++) {
                                if (in.readByte() == BulkResult.MARKER) {
                                        int len = readInt(in);
                                        bytes[i] = new byte[len];
                                        in.readBytes(bytes[i]);
                                        if (in.bytesBefore((byte) Result.CR) != 0) {
                                                throw new PikaException("Argument doesn't end in CRLF");
                                        }
                                        in.skipBytes(2);
                                        arguments++;
                                        checkpoint();
                                } else {
                                        throw new IOException("Unexpected character");
                                }
                        }
                        try {
                                out.add(new PikaCmd(bytes));
                        } finally {
                                bytes = null;
                                arguments = 0;
                        }
                } else if (in.readByte() == MultiBulkResult.MARKER) {
                        int numArgs = readInt(in);
                        if (numArgs < 0) {
                                throw new PikaException("Invalid size: " + numArgs);
                        }
                        bytes = new byte[numArgs][];
                        checkpoint();
                        decode(ctx, in, out);
                } else {
                        in.readerIndex(in.readerIndex() - 1);
                        byte[][] b = new byte[1][];
                        b[0] = in.readBytes(in.bytesBefore((byte) CR)).array();
                        in.skipBytes(2);
                        out.add(new PikaCmd(b));
                }
        }

        public int readInt(ByteBuf is) throws IOException {
                int size = 0;
                int sign = 1;
                int read = is.readByte();
                if (read == '-') {
                        read = is.readByte();
                        sign = -1;
                }
                do {
                        if (read == CR) {
                                if (is.readByte() == Result.LF) {
                                        break;
                                }
                        }
                        int value = read - '0';
                        if (value >= 0 && value < 10) {
                                size *= 10;
                                size += value;
                        } else {
                                throw new IOException("Invalid character in integer");
                        }
                        read = is.readByte();
                } while (true);
                return size * sign;
        }

}
