package com.boot.security.server.controller;


import com.alibaba.fastjson.JSONObject;
import com.boot.security.server.dao.AdvertDao;
import com.boot.security.server.model.AdvertiserData;
import com.boot.security.server.page.table.PageTableHandler;
import com.boot.security.server.page.table.PageTableRequest;
import com.boot.security.server.service.AdvertiserService;
import com.boot.security.server.utils.UserUtil;
import com.lwby.api.domain.StopAdvertRequestBo;
import com.lwby.api.facade.ICmsAdvertFacade;
import com.lwby.util.PageData;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

@RestController
@RequestMapping("/advertiserController")
public class AdvertiserController {

    @Resource
    ICmsAdvertFacade cmsAdvertFacade;

    @Autowired
    private AdvertiserService advertiserService;
    @Autowired
    private AdvertDao advertDao;

    @PostMapping("/table")
    @ApiOperation(value = "获取广告商管理数据")
    @ResponseBody
    public String getAdvertiserManagerData(@RequestBody PageTableRequest request) {
        JSONObject advertiserManagerData = advertiserService.getAdvertiserManagerData(request);
        return advertiserManagerData.toJSONString();
    }

    //返回根据日期返回所有广告汇总数据
    @PreAuthorize("hasAuthority('advert:data:count')")
    @PostMapping("/advertCount")
    @ApiOperation(value = "获取广告数据汇总")
    @ResponseBody
    public String getAdvertiserDataCount(@RequestBody PageTableRequest request) {
        Long id = UserUtil.getLoginUser().getId();
        List<AdvertiserData> advertDataList = advertDao.getAdvertData(request.getStartTime(), request.getEndTime(), id);
        Integer count = advertDao.getAdvertDataCount(request.getStartTime(), request.getEndTime(), id);
        return PageTableHandler.getJSONObject(advertDataList, count);
    }

    //返回根据日期返回所有广告主数据
    @PreAuthorize("hasAuthority('advertiser:data')")
    @PostMapping("/advertiserData")
    @ApiOperation(value = "获取广告主数据")
    @ResponseBody
    public String getAdvertiserData(@RequestBody PageTableRequest request) {
        JSONObject advertiserData = advertiserService.getAdvertiserData(request);
        return advertiserData.toJSONString();
    }

    //更新广告主数据
    @PostMapping("/updateAdvertiserData")
    @ApiOperation(value = "更新广告主管理数据")
    @ResponseBody
    public void updateAdvertiserData(@RequestBody PageTableRequest request) {
        advertiserService.updateAdvertiserManagerData(request.getAdvertiserData());
    }

    //更新广告主数据
    @PostMapping("/syncAdvertiserData")
    @ApiOperation(value = "同步cms广告主数据")
    @ResponseBody
    public void syncAdvertiserData() {
        StopAdvertRequestBo stopAdvertRequestBo = new StopAdvertRequestBo();
        List<PageData> advertListInAllAdPos = cmsAdvertFacade.getAdvertListInAllAdPos(stopAdvertRequestBo);
        advertiserService.syncAdvertiserAndAdvert();
    }
}
