package com.boot.security.server.controller;

import com.boot.security.server.dao.CopyrightDao;
import com.boot.security.server.model.BaseSettlement;
import com.boot.security.server.page.table.PageTableRequest;
import com.boot.security.server.service.CopyrightBookService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/copyrightBookController")
public class CopyrightBookController {
    @Autowired
    CopyrightBookService copyrightBookService;
    @Autowired
    CopyrightDao copyrightDao;

    @PostMapping("/settlementMonth")
    @ApiOperation(value = "获取月结算数据")
    @ResponseBody
    public String getSettlementMonthData(@RequestBody PageTableRequest request) {
        return copyrightBookService.selectSettlement(request.getCopyrightIds(),request.getPage(),request.getLimit());
    }

    @PostMapping("/settlementBookMonth")
    @ApiOperation(value = "获取书籍月结算数据")
    @ResponseBody
    public String getSettlementBookMonthData(@RequestBody PageTableRequest request) {
        return copyrightBookService.selectBookSettlement(request.getCopyrightIds(),request.getStartTime(),request.getEndTime(),request.getBookId(),request.getBookName(),request.getPage(),request.getLimit());
    }

    @PostMapping("/getAllCopyright")
    @ApiOperation(value = "版权方数据")
    @ResponseBody
    public String getAllCopyright(){
        return copyrightBookService.getAllCopyright();
    }

    @PostMapping("/getSchema")
    @ApiOperation(value = "获取总的未结算数据")
    @ResponseBody
    public String getSchema(@RequestBody PageTableRequest request){
        return copyrightBookService.getSchema(request.getCopyrightIds());
    }

    @PostMapping("/updateSettlementStatus")
    @ApiOperation(value = "更新结算状态")
    public void updateSettlementStatus(@RequestBody PageTableRequest request){
        BaseSettlement baseSettlement = request.getBaseSettlement();
        copyrightDao.updateSettlementStatus(baseSettlement.getCopyrightId(),baseSettlement.getReportDate(),baseSettlement.getStatus(),baseSettlement.getStatusName());
    }

    @PostMapping("/updateReleaseStatus")
    @ApiOperation(value = "更新结算状态")
    public void updateReleaseStatus(@RequestBody PageTableRequest request){
        BaseSettlement baseSettlement = request.getBaseSettlement();
        copyrightDao.updateReleaseStatus(baseSettlement.getCopyrightId(),baseSettlement.getReportDate(),baseSettlement.getReleaseStatus(),baseSettlement.getReleaseStatusName());
    }

    @PostMapping("/bookInfo")
    @ApiOperation(value = "获取书籍上架信息")
    @ResponseBody
    public String getBookInfo(@RequestBody PageTableRequest request) {
        return copyrightBookService.selectBookInfo(request.getCopyrightIds(),request.getPage(),request.getLimit());
    }
}
