package com.boot.security.server.dao;

import com.boot.security.server.model.AdvertiserData;
import org.apache.ibatis.annotations.*;

import java.util.List;

@Mapper
public interface AdvertDao {
    @Select("select report_date reportDate,t.advertiser_id advertiserId,advertiser_name advertiserName,code_id codeId,ecpm,cpc,exposure,click,income from advert_data_count t inner join (select advertiser_id from advertiser_user_map where user_id=#{userId} and status=1) t1 on t.advertiser_id=t1.advertiser_id where report_date>= #{startTime} and report_date<=#{endTime}")
    List<AdvertiserData> getAdvertData(@Param("startTime") String startTime, @Param("endTime") String endTime,@Param("userId") Long userId);

    @Select("select count(*) from advert_data_count t inner join (select advertiser_id from advertiser_user_map where user_id=#{userId} and status=1) t1 on t.advertiser_id=t1.advertiser_id  where report_date>= #{startTime} and report_date<=#{endTime}")
    Integer getAdvertDataCount(@Param("startTime") String startTime, @Param("endTime") String endTime,@Param("userId") Long userId);

    @Select("select advertiser_id advertiserId,advertiser_name advertiserName from advertiser_user_map t where user_id=#{userId} and status=1")
    List<AdvertiserData> getAdvertiserByUserId(@Param("userId") Long userId);

    //根据广告商di查广告id
    @Select("select code_id codeId from advert_list t where advertiser_id=#{advertiserId}")
    List<AdvertiserData> getAdvertDataById(@Param("advertiserId") Integer advertiserId);

    //从advert_list查询所有的广告商id和广告商名称
    @Select("select advertiser_id advertiserId,advertiser_name advertiserName from advert_list t group by advertiser_id,advertiser_name")
    List<AdvertiserData> getAdvertiserData();

    //从advertiser_user_map查询所有的用户
    @Select("select user_id userId from advertiser_user_map t group by user_id")
    List<AdvertiserData> getAdvertiserUserMap();

    @Select("select *,advertiser_id advertiserId,advertiser_name,total_income totalIncome,income_seven incomeSeven,income_thirty incomeThirty,exposure_view exposureView,click_view clickView from advertiser_data_count t where advertiser_id=#{advertiserId}")
    AdvertiserData getAdvertiserDataById(@Param("advertiserId") Integer advertiserId);

    @Select("select minutes,sum(exposure) exposure,sum(click) click from advertiser_data_minutes t where advertiser_id=#{advertiserId} and report_date<=#{day} and report_date<=#{day} group by minutes")
    List<AdvertiserData> getAdvertExCl(@Param("advertiserId") Integer advertiserId,@Param("day") String day);

    @Select("select minutes,sum(exposure) exposure,sum(click) click from advertiser_data_minutes t where advertiser_id=#{advertiserId} and report_date<=#{day} and report_date<=#{day} and code_id=#{codeId} group by minutes")
    List<AdvertiserData> getAdvertExCls(@Param("advertiserId") Integer advertiserId,@Param("codeId") String codeId,@Param("day") String day);

    @Select("select report_date reportDate,sum(exposure) exposure,sum(click) click from advertiser_data_minutes t where advertiser_id=#{advertiserId} and report_date>=#{startTime} and report_date<=#{endTime} group by report_date")
    List<AdvertiserData> getAdvertExClDay(@Param("advertiserId") Integer advertiserId,@Param("startTime") String startTime,@Param("endTime") String endTime);

    @Select("select report_date reportDate,sum(exposure) exposure,sum(click) click from advertiser_data_minutes t where advertiser_id=#{advertiserId} and report_date>=#{startTime} and report_date<=#{endTime} and code_id=#{codeId} group by report_date")
    List<AdvertiserData> getAdvertExClDays(@Param("advertiserId") Integer advertiserId,@Param("codeId") String codeId,@Param("startTime") String startTime,@Param("endTime") String endTime);

    @Select("SELECT a.advertiser_id advertiserId,advertiser_name advertiserName,total_income totalIncome,exposure_view exposureView,click_view clickView,income,balance FROM(SELECT advertiser_id FROM advertiser_user_map WHERE user_id=#{userId} and status=1) a LEFT JOIN advertiser_data_count b ON a.advertiser_id=b.advertiser_id")
    List<AdvertiserData> getAdvertiserDataByUserId(@Param("userId") Long userId);

    @Select("SELECT count(*) FROM(SELECT advertiser_id FROM advertiser_user_map WHERE user_id=#{userId} and status=1) a LEFT JOIN advertiser_data_count b ON a.advertiser_id=b.advertiser_id")
    int getAdvertiserDataByUserIdCount(@Param("userId") Long userId);

    @Select("select report_date reportDate,advertiser_id advertiserId,advertiser_name advertiserName,code_id codeId,sum(exposure) exposure,sum(click) click from advertiser_data_minutes t where code_id=#{advertiserData.codeId} and report_date<=#{advertiserData.reportDate} and report_date<=#{advertiserData.reportDate} group by report_date,advertiser_id,advertiser_name,code_id")
    AdvertiserData getCliExExcel(@Param("advertiserData") AdvertiserData advertiserData);

    @Update("update advertiser_data_count set balance=#{balance},exposure_view=#{exposureView},click_view=#{clickView} where advertiser_id=#{advertiserId} ")
    int updateAdvertiserData(@Param("advertiserId") Integer advertiserId,@Param("balance") Double balance,@Param("exposureView") Integer exposureView,@Param("clickView") Integer clickView);

    int insertAdvertDataCount(List<AdvertiserData> list);

    int insertAdvertiserDataCount(List<AdvertiserData> list);

    int insertAdvertList(List<AdvertiserData> list);

    int insertAdvertiserData(List<AdvertiserData> list);

    int insertAdvertiserUserMap(List<AdvertiserData> list);

    //获得总收入
    @Select("SELECT advertiser_id advertiserId,advertiser_name advertiserName,SUM(income) totalIncome FROM advert_data_count GROUP BY advertiser_id,advertiser_name")
    List<AdvertiserData> getAdvertiserDataTotalIncome();

    int insertAdvertiserDataTotalIncome(List<AdvertiserData> list);

    //获得昨日收入
    @Select("SELECT advertiser_id,advertiser_name,SUM(income) income FROM advert_data_count WHERE report_date>=DATE_SUB(DATE_FORMAT(NOW(),'%Y-%m-%d'),INTERVAL 1 DAY) AND report_date<=DATE_SUB(DATE_FORMAT(NOW(),'%Y-%m-%d'),INTERVAL 1 DAY) GROUP BY advertiser_id,advertiser_name")
    List<AdvertiserData> getAdvertiserDataIncome();

    int insertAdvertiserDataIncome(List<AdvertiserData> list);

    //获得七日收入
    @Select("SELECT advertiser_id,advertiser_name,SUM(income) incomeSeven FROM advert_data_count WHERE report_date>=DATE_SUB(DATE_FORMAT(NOW(),'%Y-%m-%d'),INTERVAL 7 DAY) AND report_date<=DATE_SUB(DATE_FORMAT(NOW(),'%Y-%m-%d'),INTERVAL 1 DAY) GROUP BY advertiser_id,advertiser_name")
    List<AdvertiserData> getAdvertiserDataSevenIncome();

    int insertAdvertiserDataSevenIncome(List<AdvertiserData> list);

    //获得三十日收入
    @Select("SELECT advertiser_id,advertiser_name,SUM(income) incomeThirty FROM advert_data_count WHERE report_date>=DATE_SUB(DATE_FORMAT(NOW(),'%Y-%m-%d'),INTERVAL 30 DAY) AND report_date<=DATE_SUB(DATE_FORMAT(NOW(),'%Y-%m-%d'),INTERVAL 1 DAY) GROUP BY advertiser_id,advertiser_name")
    List<AdvertiserData> getAdvertiserDataThirtyIncome();

    int insertAdvertiserDataThirtyIncome(List<AdvertiserData> list);

    //把分时曝光插入
    int insertAdvertDataMinuteEx(List<AdvertiserData> list);

    //把分时点击插入
    int insertAdvertDataMinuteCl(List<AdvertiserData> list);
}
