package com.boot.security.server.dao;

import com.boot.security.server.model.BaseSettlement;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.util.List;

@Mapper
public interface CopyrightDao {
    @Select("select roleId from sys_role_user where userId=#{userId}")
    Integer selectRoleId(@Param("userId") Long userId);

    @Select("SELECT a.report_date AS reportDate,a.copyright_id as copyrightId from bi_report.report_book_settlement_month a where a.release_status =1")
    List<BaseSettlement> selectReleaseCopyright();

    List<Long> selectUserAll();

    List<BaseSettlement>  selectTableListMonth(@Param("copyrightId") List<BaseSettlement> copyrightId,@Param("page") Integer page,@Param("limit")Integer limit,@Param("status") Integer status);

    List<BaseSettlement>  selectTableListMonthSchema(@Param("copyrightId") List<BaseSettlement> copyrightId,@Param("status") Integer status);

    Integer selectTableListMonthCount(@Param("copyrightId") List<BaseSettlement> copyrightId,@Param("status") Integer status);

    List<BaseSettlement> selectBookInfo(@Param("copyrightId") List<BaseSettlement> copyrightId,@Param("page") Integer page,@Param("limit")Integer limit);

    Integer selectBookInfoCount(@Param("copyrightId") List<BaseSettlement> copyrightId);

    List<BaseSettlement> selectCopyrightById(@Param("userId") Long userId);

    @Select("SELECT a.copyright_id as copyrightId,a.copyright_name as copyrightName FROM bi_report.book_banquanweihu a group by a.copyright_id,a.copyright_name")
    List<BaseSettlement> selectCopyrightAll();

    List<BaseSettlement> selectBookDetail(@Param("copyrightIdList") List<BaseSettlement> copyrightIdList,@Param("bookId") Long bookId,@Param("bookName") String bookName,@Param("startTime") String startTime,@Param("endTime") String endTime,@Param("page") Integer page,@Param("limit")Integer limit);

    Integer selectBookDetailCount(@Param("copyrightIdList") List<BaseSettlement> copyrightIdList,@Param("bookId") Long bookId,@Param("bookName") String bookName,@Param("startTime") String startTime,@Param("endTime") String endTime);

    @Update("update bi_report.report_book_settlement_month set jiesuan_status=#{status},jiesuan_status_name=#{statusName} where report_date=#{reportDate} and copyright_id=#{copyrightId}")
    int updateSettlementStatus(@Param("copyrightId") Integer copyrightId,@Param("reportDate") String reportDate,@Param("status") Integer status,@Param("statusName") String statusName);

    @Update("update bi_report.report_book_settlement_month set release_status=#{releaseStatus},release_status_name=#{releaseStatusName} where report_date=#{reportDate} and copyright_id=#{copyrightId}")
    int updateReleaseStatus(@Param("copyrightId") Integer copyrightId,@Param("reportDate") String reportDate,@Param("releaseStatus") Integer releaseStatus,@Param("releaseStatusName") String releaseStatusName);

    int updateUserCopyrightMap(List<BaseSettlement> baseSettlements);
}
