package com.boot.security.server.dao;

import java.util.List;
import java.util.Map;

import com.boot.security.server.model.AdvertiserUserMap;
import com.boot.security.server.model.BaseSettlement;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Options;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import com.boot.security.server.model.SysUser;

@Mapper
public interface UserDao {

	@Options(useGeneratedKeys = true, keyProperty = "id")
	@Insert("insert into sys_user(username, password, nickname, headImgUrl, phone, telephone, email, birthday, sex, status, createTime, updateTime) values(#{username}, #{password}, #{nickname}, #{headImgUrl}, #{phone}, #{telephone}, #{email}, #{birthday}, #{sex}, #{status}, now(), now())")
	int save(SysUser user);

	int insertCopyrightUserMap(@Param("userId") Long userId, @Param("copyrightUserMap") List<BaseSettlement> baseSettlement);

	@Select("select * from sys_user t where t.id = #{id}")
	SysUser getById(Long id);

	//查询所有的广告商
	@Select("SELECT a.copyright_id as copyrightId,a.copyright_name as copyrightName FROM bi_report.book_banquanweihu a group by a.copyright_id,a.copyright_name")
	List<BaseSettlement> getCopyrightAll();

	//查询广告商用户的映射关系
	List<BaseSettlement> getCopyrightUserMap();

	@Select("select * from sys_user t where t.username = #{username}")
	SysUser getUser(String username);

	@Update("update sys_user t set t.password = #{password} where t.id = #{id}")
	int changePassword(@Param("id") Long id, @Param("password") String password);

	Integer count(@Param("params") Map<String, Object> params);

	Integer countCopyrightUserMap(@Param("params") Map<String, Object> params);

	List<SysUser> list(@Param("params") Map<String, Object> params, @Param("offset") Integer offset,
			@Param("limit") Integer limit);

	@Delete("delete from sys_role_user where userId = #{userId}")
	int deleteUserRole(Long userId);

	int saveUserRoles(@Param("userId") Long userId, @Param("roleIds") List<Long> roleIds);

	int updateBaseSettlementUserMap(@Param("userId") Long userId, @Param("baseSettlementMap") List<BaseSettlement> baseSettlements);

	int update(SysUser user);
}
