package com.boot.security.server.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.boot.security.server.dao.CopyrightDao;
import com.boot.security.server.model.BaseSettlement;
import com.boot.security.server.page.table.PageTableHandler;
import com.boot.security.server.service.CopyrightBookService;
import com.boot.security.server.utils.UserUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@Service
public class CopyrightBookServiceImpl implements CopyrightBookService {
    @Autowired
    CopyrightDao copyrightDao;


    @Override
    public String selectSettlement(Integer copyrightId,Integer page,Integer limit) {
        Integer roleId = copyrightDao.selectRoleId(UserUtil.getLoginUser().getId());
        Integer status=null;
        List<BaseSettlement> baseSettlementList =new ArrayList<>();
        if(copyrightId==null||copyrightId==0){
            baseSettlementList = copyrightDao.selectCopyrightById(UserUtil.getLoginUser().getId());
        }else {
            BaseSettlement baseSettlement = new BaseSettlement();
            baseSettlement.setCopyrightId(copyrightId);
            baseSettlementList.add(baseSettlement);
        }
        if(roleId!=3){
            status=1;
        }
        List<BaseSettlement> baseSettlements = copyrightDao.selectTableListMonth(baseSettlementList,page-1,limit,status);

        DecimalFormat df = new DecimalFormat("#.00");
        for (BaseSettlement baseSettlement : baseSettlements) {
            Double totalAmount = baseSettlement.getTotalAmount();
            Double count=0.0;
            if(totalAmount<=2000.0){
                count=totalAmount;
            }else if(totalAmount>=2001.0&&totalAmount<=5000.0){
                Double a1=totalAmount-2000.0;
                count=2000.0+a1*0.5;
            }else if(totalAmount>=5001.0&&totalAmount<=10000.0){
                Double a1=totalAmount-5000.0;
                count=2000.0+3000*0.5+a1*0.2;
            }else if(totalAmount>=10001.0&&totalAmount<=30000.0){
                Double a1=totalAmount-10000.0;
                count=2000.0+3000*0.5+5000*0.2+a1*0.2;
            }else if(totalAmount>=30001.0&&totalAmount<=50000.0){
                Double a1=totalAmount-30000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2+a1*0.15;
            }else if(totalAmount>=50001.0&&totalAmount<=100000.0){
                Double a1=totalAmount-50000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2*2+a1*0.15;
            }else if(totalAmount>=100001.0&&totalAmount<=300000.0){
                Double a1=totalAmount-100000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2*2+50000*0.15+a1*0.1;
            }else if(totalAmount>=300001.0&&totalAmount<=500000.0){
                Double a1=totalAmount-300000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2*2+50000*0.15+200000*0.1+a1*0.05;
            }else if(totalAmount>=500001.0&&totalAmount<=1000000.0){
                Double a1=totalAmount-500000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2*2+50000*0.15+200000*0.1*2+a1*0.02;
            }else if(totalAmount>=1000001.0&&totalAmount<=3000000.0){
                Double a1=totalAmount-1000000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2*2+50000*0.15+200000*0.1*2+500000*0.02+a1*0.02;
            }else if(totalAmount>=3000001.0&&totalAmount<=5000000.0){
                Double a1=totalAmount-3000000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2*2+50000*0.15+200000*0.1*2+500000*0.02+2000000*0.02+a1*0.02;
            }
            count=Double.valueOf(df.format(count));
            baseSettlement.setTotalAmount(count);
            baseSettlement.setSettlementAmount(Double.valueOf(df.format(count*0.5)));
            count=0.0;
            Double totalAdvertAmount = baseSettlement.getTotalAdvertAmount();
            if(totalAdvertAmount<=2000.0){
                count=totalAdvertAmount;
            }else if(totalAdvertAmount>=2001.0&&totalAdvertAmount<=5000.0){
                Double a1=totalAdvertAmount-2000.0;
                count=2000.0+a1*0.5;
            }else if(totalAdvertAmount>=5001.0&&totalAdvertAmount<=10000.0){
                Double a1=totalAdvertAmount-5000.0;
                count=2000.0+3000*0.5+a1*0.2;
            }else if(totalAdvertAmount>=10001.0&&totalAdvertAmount<=30000.0){
                Double a1=totalAdvertAmount-10000.0;
                count=2000.0+3000*0.5+5000*0.2+a1*0.2;
            }else if(totalAdvertAmount>=30001.0&&totalAdvertAmount<=50000.0){
                Double a1=totalAdvertAmount-30000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2+a1*0.15;
            }else if(totalAdvertAmount>=50001.0&&totalAdvertAmount<=100000.0){
                Double a1=totalAdvertAmount-50000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2*2+a1*0.15;
            }else if(totalAdvertAmount>=100001.0&&totalAdvertAmount<=300000.0){
                Double a1=totalAdvertAmount-100000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2*2+50000*0.15+a1*0.1;
            }else if(totalAdvertAmount>=300001.0&&totalAdvertAmount<=500000.0){
                Double a1=totalAdvertAmount-300000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2*2+50000*0.15+200000*0.1+a1*0.05;
            }else if(totalAdvertAmount>=500001.0&&totalAdvertAmount<=1000000.0){
                Double a1=totalAdvertAmount-500000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2*2+50000*0.15+200000*0.1*2+a1*0.02;
            }else if(totalAdvertAmount>=1000001.0&&totalAdvertAmount<=3000000.0){
                Double a1=totalAdvertAmount-1000000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2*2+50000*0.15+200000*0.1*2+500000*0.02+a1*0.02;
            }else if(totalAdvertAmount>=3000001.0&&totalAdvertAmount<=5000000.0){
                Double a1=totalAdvertAmount-3000000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2*2+50000*0.15+200000*0.1*2+500000*0.02+2000000*0.02+a1*0.02;
            }
            count=Double.valueOf(df.format(count));
            Integer id = baseSettlement.getCopyrightId();
            if(id==3219||id==3230||id==3254||id==3253){
                count=Double.valueOf(df.format(baseSettlement.getTotalAmount()+count));
                baseSettlement.setTotalAmount(count);
                baseSettlement.setSettlementAmount(Double.valueOf(df.format(count*0.5)));
                baseSettlement.setTotalAdvertAmount(0d);
                baseSettlement.setSettlementAdAmount(0d);
            }else {
                baseSettlement.setTotalAdvertAmount(count);
                baseSettlement.setSettlementAdAmount(Double.valueOf(df.format(count*0.5)));
            }
            baseSettlement.setCountSettlement(Double.valueOf(df.format(baseSettlement.getSettlementAmount()+baseSettlement.getSettlementAdAmount())));
        }
        Integer count = copyrightDao.selectTableListMonthCount(baseSettlementList,status);
        return PageTableHandler.getJSONObject(baseSettlements,count);
    }

    @Override
    public String selectBookSettlement(Integer copyrightId,String startTime,String endTime,Long bookId,String bookName,Integer page,Integer limit) {
        Integer roleId = copyrightDao.selectRoleId(UserUtil.getLoginUser().getId());
        List<BaseSettlement> baseSettlementList =new ArrayList<>();
        if(copyrightId==null||copyrightId==0){
            baseSettlementList = copyrightDao.selectCopyrightById(UserUtil.getLoginUser().getId());
        }else {
            BaseSettlement baseSettlement = new BaseSettlement();
            baseSettlement.setCopyrightId(copyrightId);
            baseSettlementList.add(baseSettlement);
        }

        List<BaseSettlement> list =new ArrayList<>();

        if(roleId!=3){
            list = copyrightDao.selectReleaseCopyright();
        }
        List<BaseSettlement> baseSettlements = copyrightDao.selectBookDetail(baseSettlementList,bookId,bookName,startTime,endTime,page-1,limit);
        DecimalFormat df = new DecimalFormat("#.00");
        Iterator<BaseSettlement> iterator = baseSettlements.iterator();
        while (iterator.hasNext()) {
            BaseSettlement baseSettlement = iterator.next();
            Boolean flag=false;
            for (BaseSettlement settlement : list) {
                Integer id = settlement.getCopyrightId();
                Integer id1 = baseSettlement.getCopyrightId();
                if( (settlement.getReportDate().equals(baseSettlement.getReportDate()) ) && id.equals(id1) ){
                    flag=true;
                    break;
                }
            }
            if(roleId!=3){
                if(list==null||list.size()==0){
                    baseSettlements.clear();
                    break;
                }
            }
            if (flag==false&&list.size()>0){
                iterator.remove();
                continue;
            }
            if(baseSettlement.getTotalAmount()==null){
                    baseSettlement.setTotalAmount(0d);
            }
            if(baseSettlement.getTotalAdvertAmount()==null){
                baseSettlement.setTotalAdvertAmount(0d);
            }
            Double totalAmount = baseSettlement.getTotalAmount();
            Double count=0.0;
            if(totalAmount<=2000.0){
                count=totalAmount;
            }else if(totalAmount>=2001.0&&totalAmount<=5000.0){
                Double a1=totalAmount-2000.0;
                count=2000.0+a1*0.5;
            }else if(totalAmount>=5001.0&&totalAmount<=10000.0){
                Double a1=totalAmount-5000.0;
                count=2000.0+3000*0.5+a1*0.2;
            }else if(totalAmount>=10001.0&&totalAmount<=30000.0){
                Double a1=totalAmount-10000.0;
                count=2000.0+3000*0.5+5000*0.2+a1*0.2;
            }else if(totalAmount>=30001.0&&totalAmount<=50000.0){
                Double a1=totalAmount-30000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2+a1*0.15;
            }else if(totalAmount>=50001.0&&totalAmount<=100000.0){
                Double a1=totalAmount-50000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2*2+a1*0.15;
            }else if(totalAmount>=100001.0&&totalAmount<=300000.0){
                Double a1=totalAmount-100000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2*2+50000*0.15+a1*0.1;
            }else if(totalAmount>=300001.0&&totalAmount<=500000.0){
                Double a1=totalAmount-300000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2*2+50000*0.15+200000*0.1+a1*0.05;
            }else if(totalAmount>=500001.0&&totalAmount<=1000000.0){
                Double a1=totalAmount-500000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2*2+50000*0.15+200000*0.1*2+a1*0.02;
            }else if(totalAmount>=1000001.0&&totalAmount<=3000000.0){
                Double a1=totalAmount-1000000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2*2+50000*0.15+200000*0.1*2+500000*0.02+a1*0.02;
            }else if(totalAmount>=3000001.0&&totalAmount<=5000000.0){
                Double a1=totalAmount-3000000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2*2+50000*0.15+200000*0.1*2+500000*0.02+2000000*0.02+a1*0.02;
            }
            count=Double.valueOf(df.format(count));
            baseSettlement.setTotalAmount(count);
            baseSettlement.setSettlementAmount(Double.valueOf(df.format(count*0.5)));
            count=0.0;
            Double totalAdvertAmount = baseSettlement.getTotalAdvertAmount();
            if(totalAdvertAmount<=2000.0){
                count=totalAdvertAmount;
            }else if(totalAdvertAmount>=2001.0&&totalAdvertAmount<=5000.0){
                Double a1=totalAdvertAmount-2000.0;
                count=2000.0+a1*0.5;
            }else if(totalAdvertAmount>=5001.0&&totalAdvertAmount<=10000.0){
                Double a1=totalAdvertAmount-5000.0;
                count=2000.0+3000*0.5+a1*0.2;
            }else if(totalAdvertAmount>=10001.0&&totalAdvertAmount<=30000.0){
                Double a1=totalAdvertAmount-10000.0;
                count=2000.0+3000*0.5+5000*0.2+a1*0.2;
            }else if(totalAdvertAmount>=30001.0&&totalAdvertAmount<=50000.0){
                Double a1=totalAdvertAmount-30000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2+a1*0.15;
            }else if(totalAdvertAmount>=50001.0&&totalAdvertAmount<=100000.0){
                Double a1=totalAdvertAmount-50000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2*2+a1*0.15;
            }else if(totalAdvertAmount>=100001.0&&totalAdvertAmount<=300000.0){
                Double a1=totalAdvertAmount-100000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2*2+50000*0.15+a1*0.1;
            }else if(totalAdvertAmount>=300001.0&&totalAdvertAmount<=500000.0){
                Double a1=totalAdvertAmount-300000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2*2+50000*0.15+200000*0.1+a1*0.05;
            }else if(totalAdvertAmount>=500001.0&&totalAdvertAmount<=1000000.0){
                Double a1=totalAdvertAmount-500000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2*2+50000*0.15+200000*0.1*2+a1*0.02;
            }else if(totalAdvertAmount>=1000001.0&&totalAdvertAmount<=3000000.0){
                Double a1=totalAdvertAmount-1000000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2*2+50000*0.15+200000*0.1*2+500000*0.02+a1*0.02;
            }else if(totalAdvertAmount>=3000001.0&&totalAdvertAmount<=5000000.0){
                Double a1=totalAdvertAmount-3000000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2*2+50000*0.15+200000*0.1*2+500000*0.02+2000000*0.02+a1*0.02;
            }
            count=Double.valueOf(df.format(count));
            Integer id = baseSettlement.getCopyrightId();
            if(id==3219||id==3230||id==3254||id==3253){
                count=Double.valueOf(df.format(baseSettlement.getTotalAmount()+count));
                baseSettlement.setTotalAmount(count);
                baseSettlement.setSettlementAmount(Double.valueOf(df.format(count*0.5)));
                baseSettlement.setTotalAdvertAmount(0d);
                baseSettlement.setSettlementAdAmount(0d);
            }else {
                baseSettlement.setTotalAdvertAmount(count);
                baseSettlement.setSettlementAdAmount(Double.valueOf(df.format(count*0.5)));
            }
            baseSettlement.setCountSettlement(Double.valueOf(df.format(baseSettlement.getSettlementAmount()+baseSettlement.getSettlementAdAmount())));
        }
        Integer count = copyrightDao.selectBookDetailCount(baseSettlementList,bookId,bookName,startTime,endTime);
        return PageTableHandler.getJSONObject(baseSettlements,count);
    }

    @Override
    public String getAllCopyright() {
        List<BaseSettlement> baseSettlements = copyrightDao.selectCopyrightById(UserUtil.getLoginUser().getId());
        Integer roleId = copyrightDao.selectRoleId(UserUtil.getLoginUser().getId());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data",baseSettlements);
        jsonObject.put("roleId",roleId);
        return jsonObject.toJSONString();
    }

    @Override
    public String getSchema(Integer copyrightId) {
        Double schema=0.0;
        Integer roleId = copyrightDao.selectRoleId(UserUtil.getLoginUser().getId());
        Integer status=null;
        List<BaseSettlement> baseSettlementList =new ArrayList<>();
        if(copyrightId==null||copyrightId==0){
            System.out.println(copyrightId);
            baseSettlementList = copyrightDao.selectCopyrightById(UserUtil.getLoginUser().getId());
        }else {
            BaseSettlement baseSettlement = new BaseSettlement();
            baseSettlement.setCopyrightId(copyrightId);
            baseSettlementList.add(baseSettlement);
        }
        if(roleId!=3){
            status=1;
        }
        List<BaseSettlement> baseSettlements = copyrightDao.selectTableListMonthSchema(baseSettlementList,status);

        DecimalFormat df = new DecimalFormat("#.00");
        for (BaseSettlement baseSettlement : baseSettlements) {
            Double totalAmount = baseSettlement.getTotalAmount();
            Double count=0.0;
            if(totalAmount<=2000.0){
                count=totalAmount;
            }else if(totalAmount>=2001.0&&totalAmount<=5000.0){
                Double a1=totalAmount-2000.0;
                count=2000.0+a1*0.5;
            }else if(totalAmount>=5001.0&&totalAmount<=10000.0){
                Double a1=totalAmount-5000.0;
                count=2000.0+3000*0.5+a1*0.2;
            }else if(totalAmount>=10001.0&&totalAmount<=30000.0){
                Double a1=totalAmount-10000.0;
                count=2000.0+3000*0.5+5000*0.2+a1*0.2;
            }else if(totalAmount>=30001.0&&totalAmount<=50000.0){
                Double a1=totalAmount-30000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2+a1*0.15;
            }else if(totalAmount>=50001.0&&totalAmount<=100000.0){
                Double a1=totalAmount-50000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2*2+a1*0.15;
            }else if(totalAmount>=100001.0&&totalAmount<=300000.0){
                Double a1=totalAmount-100000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2*2+50000*0.15+a1*0.1;
            }else if(totalAmount>=300001.0&&totalAmount<=500000.0){
                Double a1=totalAmount-300000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2*2+50000*0.15+200000*0.1+a1*0.05;
            }else if(totalAmount>=500001.0&&totalAmount<=1000000.0){
                Double a1=totalAmount-500000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2*2+50000*0.15+200000*0.1*2+a1*0.02;
            }else if(totalAmount>=1000001.0&&totalAmount<=3000000.0){
                Double a1=totalAmount-1000000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2*2+50000*0.15+200000*0.1*2+500000*0.02+a1*0.02;
            }else if(totalAmount>=3000001.0&&totalAmount<=5000000.0){
                Double a1=totalAmount-3000000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2*2+50000*0.15+200000*0.1*2+500000*0.02+2000000*0.02+a1*0.02;
            }
            count=Double.valueOf(df.format(count));
            baseSettlement.setTotalAmount(count);
            baseSettlement.setSettlementAmount(Double.valueOf(df.format(count*0.5)));
            count=0.0;
            Double totalAdvertAmount = baseSettlement.getTotalAdvertAmount();
            if(totalAdvertAmount<=2000.0){
                count=totalAdvertAmount;
            }else if(totalAdvertAmount>=2001.0&&totalAdvertAmount<=5000.0){
                Double a1=totalAdvertAmount-2000.0;
                count=2000.0+a1*0.5;
            }else if(totalAdvertAmount>=5001.0&&totalAdvertAmount<=10000.0){
                Double a1=totalAdvertAmount-5000.0;
                count=2000.0+3000*0.5+a1*0.2;
            }else if(totalAdvertAmount>=10001.0&&totalAdvertAmount<=30000.0){
                Double a1=totalAdvertAmount-10000.0;
                count=2000.0+3000*0.5+5000*0.2+a1*0.2;
            }else if(totalAdvertAmount>=30001.0&&totalAdvertAmount<=50000.0){
                Double a1=totalAdvertAmount-30000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2+a1*0.15;
            }else if(totalAdvertAmount>=50001.0&&totalAdvertAmount<=100000.0){
                Double a1=totalAdvertAmount-50000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2*2+a1*0.15;
            }else if(totalAdvertAmount>=100001.0&&totalAdvertAmount<=300000.0){
                Double a1=totalAdvertAmount-100000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2*2+50000*0.15+a1*0.1;
            }else if(totalAdvertAmount>=300001.0&&totalAdvertAmount<=500000.0){
                Double a1=totalAdvertAmount-300000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2*2+50000*0.15+200000*0.1+a1*0.05;
            }else if(totalAdvertAmount>=500001.0&&totalAdvertAmount<=1000000.0){
                Double a1=totalAdvertAmount-500000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2*2+50000*0.15+200000*0.1*2+a1*0.02;
            }else if(totalAdvertAmount>=1000001.0&&totalAdvertAmount<=3000000.0){
                Double a1=totalAdvertAmount-1000000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2*2+50000*0.15+200000*0.1*2+500000*0.02+a1*0.02;
            }else if(totalAdvertAmount>=3000001.0&&totalAdvertAmount<=5000000.0){
                Double a1=totalAdvertAmount-3000000.0;
                count=2000.0+3000*0.5+5000*0.2+20000*0.2*2+50000*0.15+200000*0.1*2+500000*0.02+2000000*0.02+a1*0.02;
            }
            count=Double.valueOf(df.format(count));
            Integer id = baseSettlement.getCopyrightId();
            if(id==3219||id==3230||id==3254||id==3253){
                count=Double.valueOf(df.format(baseSettlement.getTotalAmount()+count));
                baseSettlement.setTotalAmount(count);
                baseSettlement.setSettlementAmount(Double.valueOf(df.format(count*0.5)));
                baseSettlement.setTotalAdvertAmount(0d);
                baseSettlement.setSettlementAdAmount(0d);
            }else {
                baseSettlement.setTotalAdvertAmount(count);
                baseSettlement.setSettlementAdAmount(Double.valueOf(df.format(count*0.5)));
            }
            baseSettlement.setCountSettlement(Double.valueOf(df.format(baseSettlement.getSettlementAmount()+baseSettlement.getSettlementAdAmount())));
            if(baseSettlement.getStatus().equals(0)){
                schema+=Double.valueOf(df.format(baseSettlement.getSettlementAmount()+baseSettlement.getSettlementAdAmount()));
            }
        }
        Integer count = copyrightDao.selectTableListMonthCount(baseSettlementList,status);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("schema",schema);
        return jsonObject.toJSONString();
    }

    @Override
    public String selectBookInfo(Integer copyrightId,Integer page,Integer limit) {
        List<BaseSettlement> baseSettlementList =new ArrayList<>();
        if(copyrightId==null||copyrightId==0){
            baseSettlementList = copyrightDao.selectCopyrightById(UserUtil.getLoginUser().getId());
        }else {
            BaseSettlement baseSettlement = new BaseSettlement();
            baseSettlement.setCopyrightId(copyrightId);
            baseSettlementList.add(baseSettlement);
        }
        List<BaseSettlement> baseSettlements = copyrightDao.selectBookInfo(baseSettlementList,page,limit);
        Integer count = copyrightDao.selectBookInfoCount(baseSettlementList);
        return PageTableHandler.getJSONObject(baseSettlements,count);
    }

    public void updateUserCopyrightMap(){
        List<BaseSettlement> baseSettlements = copyrightDao.selectCopyrightAll();
        List<Long> users = copyrightDao.selectUserAll();
        List<BaseSettlement> baseSettlementList=new ArrayList<>();
        for (Long user : users) {
            for (BaseSettlement baseSettlement : baseSettlements) {
                BaseSettlement settlement = new BaseSettlement();
                settlement.setUserId(user);
                settlement.setCopyrightId(baseSettlement.getCopyrightId());
                settlement.setCopyrightName(baseSettlement.getCopyrightName());
                baseSettlementList.add(settlement);
            }
        }
        copyrightDao.updateUserCopyrightMap(baseSettlementList);
    }
}
