package com.boot.security.server.utils;

import com.boot.security.server.model.AdvertiserData;
import com.google.common.cache.Cache;

import java.io.InputStream;
import java.sql.*;
import java.util.*;

public class ConnectionJDBC {


    /**
     * 获取与数据库的连接
     * @author maliang
     * */
    public static Connection getConnection() throws Exception {
        //1.加载配置文件
        InputStream is  = ClassLoader.getSystemResourceAsStream("config.properties");
        Properties pros = new Properties();
        pros.load(is);

        //2.读取配置信息
        String user = pros.getProperty("user");
        String password = pros.getProperty("password");
        String url = pros.getProperty("url");
        String driverClass = pros.getProperty("driverClass");

        //System.out.println(driverClass);

        //3.加载驱动
        Class.forName(driverClass);

        //4.驱动管理器DriverManager遍历所有注册过的驱动，以便找到一个URL子协议中指定的驱动程序
        Connection conn = DriverManager.getConnection(url,user,password);
        //getConnection()方法返回一个该驱动程序提供的连接
        return conn;
    }
    /**
     * 关闭与数据库的连接
     * @author maliang
     * */
    public static void closeResource(Connection conn ,Statement statement,ResultSet rs){
        if (conn != null) {
            try {
                conn.close();
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (statement != null) {
            try {
                statement.close();
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (rs != null) {
            try {
                rs.close();
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
    /**
     * 执行查询
     * @author maliang
     * */
    public static List<AdvertiserData> getInstance(String sql, Object... args) {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        List<AdvertiserData> list=new ArrayList();
        try {
            // 1.获取数据库连接
            conn = getConnection();

            // 2.预编译sql语句，得到PreparedStatement对象
            ps = conn.prepareStatement(sql);

            // 3.填充占位符
            for (int i = 0; i < args.length; i++) {
                ps.setObject(i + 1, args[i]);
            }

            // 4.执行executeQuery(),得到结果集：ResultSet
            rs = ps.executeQuery();

            // 5.得到结果集的元数据：ResultSetMetaData
            ResultSetMetaData rsmd = rs.getMetaData();

            // 6.1通过ResultSetMetaData得到columnCount,columnLabel；通过ResultSet得到列值
            //int columnCount = rsmd.getColumnCount();
            while (rs.next()) {
                AdvertiserData advertiserData = new AdvertiserData();
                // 获取列值
                String advertiserId = rs.getString( 1);
                String advertiserName = rs.getString( 2);
                String codeId = rs.getString( 3);
                String advertName = rs.getString( 4);
                Integer platformId = rs.getInt( 5);
                // 获取列的别名:列的别名，使用类的属性名充当
                //String columnLabel = rsmd.getColumnLabel(i + 1);
                //给相应属性赋值
                advertiserData.setAdvertiserId(Integer.valueOf(advertiserId));
                advertiserData.setAdvertiserName(advertiserName);
                advertiserData.setCodeId(codeId);
                advertiserData.setCodeName(advertName);
                advertiserData.setPlatformId(platformId);
                list.add(advertiserData);
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            // 7.关闭资源
            closeResource(conn, ps, rs);
        }

        return list;

    }
}
