package com.boot.security.server.utils.redis;

import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

class RConfig {

	/** 配置文件 **/
	private final String DEFAULT_FILE = "redis.properties";

	/** 链接timeout时间 **/
	private final int POOL_TIMEOUT = 1000;

	private RNodeGroup[] nodes;

	private final Map<String, RNode> nodeMap = new HashMap<String, RNode>();

	private static RConfig config;

	private static final Object mutex = new Object();

	public static RNodeGroup[] getNodes() {
		return getConfig().nodes;
	}

	public static Map<String, RNode> getNodeMap() {

		return getConfig().nodeMap;
	}

	private static RConfig getConfig() {
		if (config == null) {
			synchronized (mutex) {
				if (config == null) {
					config = new RConfig();
				}
				return config;
			}
		}
		return config;
	}

	private RConfig() {
		initaize();
	}

	private void initaize() {

		System.out.println("redis initaizing ...");
		Properties redisProp = new Properties();
		try {
			redisProp.load(new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream("config.properties") , "UTF-8"));
			Set<Object> propKeySet = redisProp.keySet();

			for (Object obj : propKeySet) {
				System.out.println("**************key:" + obj + ",value:" + redisProp.getProperty(obj.toString()));
			}
			JedisPoolConfig pConfig = new JedisPoolConfig();
			pConfig.setMaxIdle(Integer.valueOf(redisProp.getProperty("redis.maxIdle")));
			pConfig.setMaxTotal(Integer.valueOf(redisProp.getProperty("redis.maxActive")));
			pConfig.setMinIdle(Integer.valueOf(redisProp.getProperty("redis.minIdle")));

			nodes = new RNodeGroup[Integer.valueOf(redisProp.getProperty("redis.cluster.count"))];

			for (int i = 0; i < nodes.length; i++) {

				nodes[i] = new RNodeGroup();

				String masterHost = redisProp.getProperty("redis.cluster.master." + (i + 1) + ".host");
				String masterPort = redisProp.getProperty("redis.cluster.master." + (i + 1) + ".port");

				JedisPool mPoll = new JedisPool(pConfig, masterHost, Integer.valueOf(masterPort), POOL_TIMEOUT);

				RNode masterNode = new RNode(masterHost + ":" + masterPort, mPoll);
				masterNode.setGroup(nodes[i]);

				String slaveHost = redisProp.getProperty("redis.cluster.slave." + (i + 1) + ".host");
				String slavePort = redisProp.getProperty("redis.cluster.slave." + (i + 1) + ".port");

				JedisPool sPoll = new JedisPool(pConfig, slaveHost, Integer.valueOf(slavePort), POOL_TIMEOUT);

				RNode slaveNode = new RNode(slaveHost + ":" + slavePort, sPoll);
				slaveNode.setGroup(nodes[i]);

				nodes[i].setMasterNode(masterNode);
				nodes[i].setSlaveNode(slaveNode);

				nodeMap.put(masterNode.getNodeName(), masterNode);
				nodeMap.put(slaveNode.getNodeName(), slaveNode);

			}

		} catch (FileNotFoundException e) {
			//LogHelper.exceptionLog(e);
		} catch (IOException e) {
			//LogHelper.exceptionLog(e);
		}
	}

	public static void main(String[] args) {
		System.out.println(getNodes().length);
	}

}
