package com.boot.security.server.controller;


import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.boot.security.server.dao.AdvertDao;
import com.boot.security.server.model.AdvertiserData;
import com.boot.security.server.page.table.PageTableHandler;
import com.boot.security.server.page.table.PageTableRequest;
import com.boot.security.server.page.table.PageTableResponse;
import com.boot.security.server.service.AdvertiserService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/advertiserController")
public class AdvertiserController {

    @Autowired
    private AdvertiserService advertiserService;
    @Autowired
    private AdvertDao advertDao;

    @GetMapping("/table")
    @ApiOperation(value = "获取广告商数据")
    @ResponseBody
    public String getAdvertiserData() {
        JSONObject jsonObject = new JSONObject();
        JSONObject item = new JSONObject();
        JSONArray array = new JSONArray();
        item.put("id",1);
        item.put("advertiser","麦子");
        item.put("balance",100000);
        item.put("AccumulatedConsumptionAmount",100000);
        item.put("leader","高飞");
        item.put("yesterdayConsumptionAmount",5000);
        item.put("viewData","曝光X1");
        array.add(item);
        jsonObject.put("code",0);
        jsonObject.put("msg","");
        jsonObject.put("count",1);
        jsonObject.put("data",array);
        return jsonObject.toJSONString();
    }
    //返回根据日期返回所有广告汇总数据
    @PreAuthorize("hasAuthority('advert:data:count')")
    @PostMapping("/advertCount")
    @ApiOperation(value = "获取广告数据汇总")
    @ResponseBody
    public String getAdvertiserDataCount(@RequestBody PageTableRequest request) {
        List<AdvertiserData> advertDataList = advertDao.getAdvertData(request.getStartTime(), request.getEndTime());
        Integer count = advertDao.getAdvertDataCount(request.getStartTime(), request.getEndTime());
        return PageTableHandler.getJSONObject(advertDataList,count);
    }

    //返回根据日期返回所有广告主数据
    @PreAuthorize("hasAuthority('advertiser:data')")
    @PostMapping("/advertiserData")
    @ApiOperation(value = "获取广告主数据")
    @ResponseBody
    public String getAdvertiserData(@RequestBody PageTableRequest request) {
        System.out.println(request.getAdvertiserId()+"....."+request.getAdvertId());
        List<AdvertiserData> advertDataList = advertDao.getAdvertData(request.getStartTime(), request.getEndTime());
        Integer count = advertDao.getAdvertDataCount(request.getStartTime(), request.getEndTime());
        JSONObject advertiserData = advertiserService.getAdvertiserData(request);
        advertiserData.toJSONString();
        return PageTableHandler.getJSONObject(advertDataList,count);
    }
}
