package com.boot.security.server.utils.redis;


import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPool;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class JedisManager {

	private ShardedJedisPool shardPool;


	class JedisConfig {
		private JedisConfig() {
			initaize();
		}

		//private String path="config.properties";

		private void initaize() {
			System.out.println("redis initaizing ...");

			//String path = SystemConfig.getConfig("core.properties.path");
			Properties cbuilder = new Properties();
			try {
				cbuilder.load(new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream("config.properties") , "UTF-8"));
			} catch (IOException e) {
				e.printStackTrace();
			}
			//ConfigBuilder cbuilder = ConfigBuilderFactory.getConfigBuilder(path);

			JedisPoolConfig pConfig = new JedisPoolConfig();
			pConfig.setMaxIdle(Integer.parseInt(cbuilder.getProperty("redis.maxIdle")));
			pConfig.setMaxTotal(Integer.parseInt(cbuilder.getProperty("redis.maxActive")));
			pConfig.setMinIdle(Integer.parseInt(cbuilder.getProperty("redis.minIdle")));

			int nodes = Integer.parseInt(cbuilder.getProperty("redis.cluster.count"));
			// 单位:毫秒
			Integer poolTimeout = Integer.parseInt(cbuilder.getProperty("redis.pool.timeout"));

			List<JedisShardInfo> jdinfoList = new ArrayList<JedisShardInfo>();
			for (int i = 0; i < nodes; i++) {

				String masterHost = cbuilder.getProperty("redis.cluster.master." + (i + 1) + ".host");
				String masterPort = cbuilder.getProperty("redis.cluster.master." + (i + 1) + ".port");
				String masterName = cbuilder.getProperty("redis.cluster.master." + (i + 1) + ".name", masterHost);

				JedisShardInfo jsi = new JedisShardInfo(masterHost, Integer.valueOf(masterPort), poolTimeout, masterName);

				jdinfoList.add(jsi);
			}

			shardPool = new ShardedJedisPool(pConfig, jdinfoList);
			System.out.println("redis initialize success");
		}
	}

	private JedisManager() {
		new JedisConfig();
	}

	private static JedisManager instance = new JedisManager();


	public static JedisManager getInstance() {
		return instance;
	}

	public ShardedJedis getShardedJedis() {
		return shardPool.getResource();
	}

	/**
	 * 正常归还jedis
	 * 
	 * @param jedis
	 */
	public void returnSharedJedis(final ShardedJedis jedis) {

		shardPool.returnResource(jedis);
	}

	/**
	 * jedis出现异常的时候销毁jedis
	 * 
	 * @param jedis
	 */
	public void returnBrokenSharedJedis(final ShardedJedis jedis) {
		shardPool.returnBrokenResource(jedis);
	}

	//	/**
	//	 * 根据key值获取写jedis
	//	 * 
	//	 * @param key
	//	 * @return
	//	 */
	//	public Jedis getWriteJedis(final String key) {
	//		RNodeGroup[] nodes = RConfig.getNodes();
	//		int nodeIndex = key.hashCode() % nodes.length;
	//		if (nodeIndex < 0) {
	//			nodeIndex *= -1;
	//		}
	//
	//		RNode node = nodes[nodeIndex].getMasterNode();
	//
	//		try {
	//
	//			return node.getjPool().getResource();
	//
	//		} catch (JedisConnectionException jnex) {
	//
	//			closeNode(node);
	//			node = nodes[nodeIndex].getMasterNode();
	//			return node.getjPool().getResource();
	//		}
	//
	//	}
	//
	//	/**
	//	 * 根据key值获取jedis
	//	 * 
	//	 * @param key
	//	 * @return
	//	 */
	//	public Jedis getReadJedis(final String key) {
	//
	//		RNodeGroup[] nodes = RConfig.getNodes();
	//		int nodeIndex = key.hashCode() % nodes.length;
	//
	//		if (nodeIndex < 0) {
	//			nodeIndex *= -1;
	//		}
	//
	//		RNode node = nodes[nodeIndex].getReadNode();
	//		try {
	//
	//			return node.getjPool().getResource();
	//
	//		} catch (JedisConnectionException jnex) {
	//			closeNode(node);
	//			node = nodes[nodeIndex].getReadNode();
	//			return node.getjPool().getResource();
	//		}
	//
	//	}
	//
	//	/**
	//	 * 正常归还jedis
	//	 * 
	//	 * @param jedis
	//	 */
	//	public void returnJedis(final Jedis jedis) {
	//
	//		String nodeName = jedis.getClient().getHost() + ":" + jedis.getClient().getPort();
	//		RNode node = RConfig.getNodeMap().get(nodeName);
	//		if (node != null) {
	//			node.getjPool().returnResource(jedis);
	//		}
	//	}
	//
	//	/**
	//	 * jedis出现异常的时候销毁jedis
	//	 * 
	//	 * @param jedis
	//	 */
	//	public void returnBrokenJedis(final Jedis jedis) {
	//
	//		String nodeName = jedis.getClient().getHost() + ":" + jedis.getClient().getPort();
	//		RNode node = RConfig.getNodeMap().get(nodeName);
	//		if (node != null) {
	//			node.getjPool().returnBrokenResource(jedis);
	//		}
	//	}
	//
	//	/**
	//	 * 无法连接的时候调用
	//	 * 
	//	 * @param jedis
	//	 */
	//	private void closeNode(final RNode rnode) {
	//
	//		RNode masterNode = rnode.getGroup().getMasterNode();
	//
	//		// 表示已经是同一个节点了
	//		if (rnode.getGroup().getSlaveNode() == rnode.getGroup().getMasterNode()) {
	//
	//			// do nothing
	//			return;
	//		}
	//
	//		// 是主还是从
	//		if (rnode == masterNode) {
	//
	//			rnode.getGroup().getSlaveNode().getjPool().getResource().slaveofNoOne();
	//
	//			rnode.getGroup().setMasterNode(rnode.getGroup().getSlaveNode());
	//
	//		} else {
	//			rnode.getGroup().setSlaveNode(rnode.getGroup().getMasterNode());
	//		}
	//
	//		RConfig.getNodeMap().remove(rnode.getNodeName());
	//
	//	}

}
