package com.boot.security.server.controller;


import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.boot.security.server.dao.AdvertDao;
import com.boot.security.server.model.AdvertiserData;
import com.boot.security.server.page.table.PageTableHandler;
import com.boot.security.server.page.table.PageTableRequest;
import com.boot.security.server.service.AdvertiserService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/advertiserController")
public class AdvertiserController {

    @Autowired
    private AdvertiserService advertiserService;
    @Autowired
    private AdvertDao advertDao;

    @PostMapping("/table")
    @ApiOperation(value = "获取广告商管理数据")
    @ResponseBody
    public String getAdvertiserManagerData(@RequestBody PageTableRequest request) {
        JSONObject advertiserManagerData = advertiserService.getAdvertiserManagerData(request);
        return advertiserManagerData.toJSONString();
    }
    //返回根据日期返回所有广告汇总数据
    @PreAuthorize("hasAuthority('advert:data:count')")
    @PostMapping("/advertCount")
    @ApiOperation(value = "获取广告数据汇总")
    @ResponseBody
    public String getAdvertiserDataCount(@RequestBody PageTableRequest request) {
        List<AdvertiserData> advertDataList = advertDao.getAdvertData(request.getStartTime(), request.getEndTime());
        Integer count = advertDao.getAdvertDataCount(request.getStartTime(), request.getEndTime());
        return PageTableHandler.getJSONObject(advertDataList,count);
    }

    //返回根据日期返回所有广告主数据
    @PreAuthorize("hasAuthority('advertiser:data')")
    @PostMapping("/advertiserData")
    @ApiOperation(value = "获取广告主数据")
    @ResponseBody
    public String getAdvertiserData(@RequestBody PageTableRequest request) {
        List<AdvertiserData> advertDataList = advertDao.getAdvertData(request.getStartTime(), request.getEndTime());
        Integer count = advertDao.getAdvertDataCount(request.getStartTime(), request.getEndTime());
        JSONObject advertiserData = advertiserService.getAdvertiserData(request);
        return advertiserData.toJSONString();
    }

    //更新广告主数据
    @PostMapping("/updateAdvertiserData")
    @ApiOperation(value = "更新广告主管理数据")
    @ResponseBody
    public void updateAdvertiserData(@RequestBody PageTableRequest request) {
        advertiserService.updateAdvertiserManagerData(request.getAdvertiserData());
    }
}
