package com.boot.security.server.dao;

import com.boot.security.server.model.AdvertiserData;
import org.apache.ibatis.annotations.*;

import java.util.List;

@Mapper
public interface AdvertDao {
    @Select("select report_date reportDate,advertiser_id advertiserId,advertiser_name advertiserName,code_id codeId,ecpm,cpc,exposure,click,income from advert_data_count t where report_date>= #{startTime} and report_date<=#{endTime}")
    List<AdvertiserData> getAdvertData(@Param("startTime") String startTime, @Param("endTime") String endTime);

    @Select("select count(*) from advert_data_count t where report_date>= #{startTime} and report_date<=#{endTime}")
    Integer getAdvertDataCount(@Param("startTime") String startTime, @Param("endTime") String endTime);

    @Select("select advertiser_id advertiserId,advertiser_name advertiserName from advertiser_user_map t where user_id=#{userId} and status=1")
    List<AdvertiserData> getAdvertiserByUserId(@Param("userId") Long userId);

    @Select("select code_id codeId from advert_list t where advertiser_id=#{advertiserId}")
    List<AdvertiserData> getAdvertDataById(@Param("advertiserId") Integer advertiserId);

    @Select("select *,advertiser_id advertiserId,advertiser_name,total_income totalIncome,income_seven incomeSeven,income_thirty incomeThirty,exposure_view exposureView,click_view clickView from advertiser_data_count t where advertiser_id=#{advertiserId}")
    AdvertiserData getAdvertiserDataById(@Param("advertiserId") Integer advertiserId);

    @Select("select minutes,sum(exposure) exposure,sum(click) click from advertiser_data_minutes t where advertiser_id=#{advertiserId} and report_date<=#{day} and report_date<=#{day} group by minutes")
    List<AdvertiserData> getAdvertExCl(@Param("advertiserId") Integer advertiserId,@Param("day") String day);

    @Select("select minutes,sum(exposure) exposure,sum(click) click from advertiser_data_minutes t where advertiser_id=#{advertiserId} and report_date<=#{day} and report_date<=#{day} and code_id=#{codeId} group by minutes")
    List<AdvertiserData> getAdvertExCls(@Param("advertiserId") Integer advertiserId,@Param("codeId") String codeId,@Param("day") String day);

    @Select("select report_date reportDate,sum(exposure) exposure,sum(click) click from advertiser_data_minutes t where advertiser_id=#{advertiserId} and report_date>=#{startTime} and report_date<=#{endTime} and code_id=#{codeId} group by report_date")
    List<AdvertiserData> getAdvertExClDay(@Param("advertiserId") Integer advertiserId,@Param("startTime") String startTime,@Param("endTime") String endTime);

    @Select("select report_date reportDate,sum(exposure) exposure,sum(click) click from advertiser_data_minutes t where advertiser_id=#{advertiserId} and report_date>=#{startTime} and report_date<=#{endTime} and code_id=#{codeId} group by report_date")
    List<AdvertiserData> getAdvertExClDays(@Param("advertiserId") Integer advertiserId,@Param("codeId") String codeId,@Param("startTime") String startTime,@Param("endTime") String endTime);

    @Select("SELECT a.advertiser_id advertiserId,advertiser_name advertiserName,total_income totalIncome,exposure_view exposureView,click_view clickView,income,balance FROM(SELECT advertiser_id FROM advertiser_user_map WHERE user_id=#{userId}) a LEFT JOIN advertiser_data_count b ON a.advertiser_id=b.advertiser_id")
    List<AdvertiserData> getAdvertiserDataByUserId(@Param("userId") Long userId);
    @Select("SELECT count(*) FROM(SELECT advertiser_id FROM advertiser_user_map WHERE user_id=#{userId}) a LEFT JOIN advertiser_data_count b ON a.advertiser_id=b.advertiser_id")
    int getAdvertiserDataByUserIdCount(@Param("userId") Long userId);

    @Select("select report_date reportDate,advertiser_id advertiserId,advertiser_name advertiserName,code_id codeId,sum(exposure) exposure,sum(click) click from advertiser_data_minutes t where code_id=#{advertiserData.codeId} and report_date<=#{advertiserData.reportDate} and report_date<=#{advertiserData.reportDate} group by report_date,advertiser_id,advertiser_name,code_id")
    AdvertiserData getCliExExcel(@Param("advertiserData") AdvertiserData advertiserData);

    @Update("update advertiser_data_count set balance=#{balance},exposure_view=#{exposureView},click_view=#{clickView} where advertiser_id=#{advertiserId} ")
    int updateAdvertiserData(@Param("advertiserId") Integer advertiserId,@Param("balance") Double balance,@Param("exposureView") Integer exposureView,@Param("clickView") Integer clickView);

    int insertAdvertDataCount(List<AdvertiserData> list);
}
