#!/bin/bash
cd `dirname $0`
BIN_DIR=`pwd`
DEPLOY_DIR=`pwd`

IP=$(echo $SSH_CONNECTION | awk '{print $3}')
echo $IP

# 
# $1 方法名 deploy 发布项目
# $2 项目目录
# $3 检查的url
#
function deploy() {
    cd $2
    sh -x ./restart.sh
    COUNT=0
    TIMES=0
    if [ -n "$3" ]; then
        while [ $COUNT -lt 1 ]; do
        echo -e ".\c"
        sleep 1
        COUNT=`curl -v "$3" | grep "success" | wc -l`
        if [ $COUNT -gt 0 ]; then
            break
        fi
        let TIMES=TIMES+1
        if [ $TIMES -gt 200 ]; then
            exit 1
        fi
    done
    fi
}
# 
# $1 方法名 检查项目环境
# $2 项目目录
#
function check() {
    return;
}


# $1 方法名 设置权重
# $2 虚拟主机组
# $3 weight 权重
#
function weight() {
    echo "http://172.17.255.136:8084/api/deploy/slb/controlSLB?ipStrList=$IP&vGroupId=$2&weight=$3"
    curl "http://172.17.255.136:8084/api/deploy/slb/controlSLB?ipStrList=$IP&vGroupId=$2&weight=$3"

    exit 1
}
if [ $1 -z ]; then
    $1 = "deploy"
fi
echo call $1
case $1 in
    deploy)
        deploy $*
        ;;
    check)
        check $*
        ;;
    weight)
        weight $*
        ;;
    error)
        exit 1
        ;;
    *)
        deploy "deploy" $*
esac



